/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;

public class ElementValuePairGen {
    private int nameIdx;
    private ElementValueGen value;
    private ConstantPoolGen cpool;

    public ElementValuePairGen(ElementValuePair nvp, ConstantPoolGen cpool, boolean copyPoolEntries) {
        this.cpool = cpool;
        this.nameIdx = copyPoolEntries ? cpool.addUtf8(nvp.getNameString()) : nvp.getNameIndex();
        this.value = ElementValueGen.copy(nvp.getValue(), cpool, copyPoolEntries);
    }

    public ElementValuePair getElementNameValuePair() {
        ElementValue immutableValue = this.value.getElementValue();
        return new ElementValuePair(this.nameIdx, immutableValue, this.cpool.getConstantPool());
    }

    protected ElementValuePairGen(int idx, ElementValueGen value, ConstantPoolGen cpool) {
        this.nameIdx = idx;
        this.value = value;
        this.cpool = cpool;
    }

    public ElementValuePairGen(String name, ElementValueGen value, ConstantPoolGen cpool) {
        this.nameIdx = cpool.addUtf8(name);
        this.value = value;
        this.cpool = cpool;
    }

    protected void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.nameIdx);
        this.value.dump(dos);
    }

    public int getNameIndex() {
        return this.nameIdx;
    }

    public final String getNameString() {
        return ((ConstantUtf8)this.cpool.getConstant(this.nameIdx)).getBytes();
    }

    public final ElementValueGen getValue() {
        return this.value;
    }

    public String toString() {
        return "ElementValuePair:[" + this.getNameString() + "=" + this.value.stringifyValue() + "]";
    }
}

