/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    ByteBuffer bb;

    public ByteBufferOutputStream(ByteBuffer bb) {
        this.bb = bb;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bb == null) {
            throw new IOException("Buffer is not initialized");
        }
        this.bb.put((byte)b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int numBytes) throws IOException {
        if (this.bb == null) {
            throw new IOException("Buffer is not initialized");
        }
        if (offset < 0 || offset > bytes.length || numBytes < 0 || offset + numBytes > bytes.length || offset + numBytes < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (numBytes == 0) {
            return;
        }
        this.bb.put(bytes, offset, numBytes);
    }

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }
}

