/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.util;

import es.bsc.comm.exceptions.NonInstantiableException;
import es.bsc.comm.exceptions.SerializerException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Serializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.comm.Serializer");
    private static final String ERROR_CANNOT_SERIALIZE = "Can not serialize ";
    private static final String ERROR_CANNOT_DESERIALIZE = "Can not deserialize ";
    private static final String ERROR_BINARY_SERIALIZER = " by binary serializer";
    private static final String ERROR_XML_SERIALIZER = " by XML serializer";
    private static final String ERROR_RETRY = ". Trying with another serializer";

    private Serializer() {
        throw new NonInstantiableException("Serializer");
    }

    public static byte[] serialize(Object o) throws SerializerException {
        try {
            return Serializer.serializeBinary(o);
        }
        catch (IOException ioe) {
            LOGGER.debug(ERROR_CANNOT_SERIALIZE + o + ERROR_BINARY_SERIALIZER + ERROR_RETRY, (Throwable)ioe);
            try {
                byte[] res = Serializer.serializeXML(o);
                LOGGER.debug("Object serialized by XML Serialization");
                return res;
            }
            catch (IOException ioe2) {
                LOGGER.debug(ERROR_CANNOT_SERIALIZE + o + ERROR_XML_SERIALIZER, (Throwable)ioe2);
                throw new SerializerException(ioe2);
            }
        }
    }

    public static Object deserialize(byte[] b) throws SerializerException {
        try {
            return Serializer.deserializeBinary(b);
        }
        catch (SerializerException se) {
            LOGGER.debug(ERROR_CANNOT_DESERIALIZE + b + ERROR_BINARY_SERIALIZER + ERROR_RETRY, (Throwable)se);
            try {
                Object obj = Serializer.deserializeXML(b);
                LOGGER.debug("ByteArray deserialized by XML Serialization");
                return obj;
            }
            catch (SerializerException se2) {
                LOGGER.error(ERROR_CANNOT_DESERIALIZE + Arrays.toString(b) + ERROR_XML_SERIALIZER, (Throwable)se2);
                throw se2;
            }
        }
    }

    private static byte[] serializeBinary(Object o) throws IOException {
        byte[] res;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(o);
            out.flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            byte[] res2 = bos.toByteArray();
            bos.close();
        }
        return res;
    }

    private static byte[] serializeXML(Object o) throws IOException {
        byte[] res;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BufferedOutputStream bos = new BufferedOutputStream(baos);
             XMLEncoder xmlEncoder = new XMLEncoder(bos);){
            xmlEncoder.writeObject(o);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            byte[] res2 = baos.toByteArray();
            baos.close();
        }
        return res;
    }

    private static Object deserializeBinary(byte[] data) throws SerializerException {
        Object obj;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);
             ObjectInputStream in = new ObjectInputStream(bis);){
            obj = in.readObject();
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
        return obj;
    }

    private static Object deserializeXML(byte[] data) throws SerializerException {
        Object obj;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);
             BufferedInputStream bis = new BufferedInputStream(bais);
             XMLDecoder d = new XMLDecoder(bis);){
            obj = d.readObject();
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
        return obj;
    }
}

