/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.CommProperties;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.Node;
import es.bsc.comm.event.Event;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.exceptions.StageException;
import es.bsc.comm.exceptions.ViabilityException;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIOListener;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.nio.event.NIOEvent;
import es.bsc.comm.nio.event.NewTransferEvent;
import es.bsc.comm.nio.exceptions.NIOException;
import es.bsc.comm.stage.Reception;
import es.bsc.comm.stage.Shutdown;
import es.bsc.comm.stage.Stage;
import es.bsc.comm.stage.Submission;
import es.bsc.comm.stage.Transfer;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOConnection
implements Connection,
InternalConnection {
    private static final Logger LOGGER = LogManager.getLogger((String)"Communication.NIO.Connection");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String MSG_WITH_CONNECTION = " with connection: ";
    private static final String MSG_ON_CONNECTION = " on connection ";
    private static final String ERROR_NIO = "NIO ERROR";
    private static final String REQ_TRANSFER = "Requesting transfer ";
    private static final String ERROR_CHANNEL_CLOSED = "Channel was already closed for connection ";
    private static final List<NIOConnection> PENDING_ESTABLISH_CONNECTIONS = new LinkedList<NIOConnection>();
    private SocketChannel sc;
    private boolean established;
    private boolean paused;
    private boolean closedSocket;
    private boolean closedConnection;
    private int conRetries = 0;
    protected Stage currentStage;
    private final LinkedList<Stage> pendingStages;
    private final List<ByteBuffer> receiveBuffer;
    private final List<ByteBuffer> sendBuffer;
    private final NIONode node;
    private final EventManager<NIOEvent> em;
    private final NIOListener nl;

    public NIOConnection(NIOEventManager ntm, NIOListener nl, SocketChannel sc, NIONode n) {
        this.em = ntm;
        this.nl = nl;
        this.node = n;
        this.currentStage = null;
        this.pendingStages = new LinkedList();
        this.receiveBuffer = new LinkedList<ByteBuffer>();
        this.sendBuffer = new LinkedList<ByteBuffer>();
        this.established = false;
        this.closedSocket = false;
        this.closedConnection = false;
        if (sc != null) {
            this.registerChannel(sc);
        }
    }

    public Node getNode() {
        return this.node;
    }

    public void sendCommand(Object cmd) {
        Submission t = new Submission(Transfer.Type.COMMAND, cmd);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void sendDataFile(String name) {
        Submission t = new Submission(name);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void sendDataObject(Object o) {
        Submission t = new Submission(Transfer.Type.DATA, o);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void sendDataArray(byte[] array) {
        Submission t = new Submission(Transfer.Type.DATA, array);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void sendDataByteBuffer(ByteBuffer bb) {
        Submission t = new Submission(Transfer.Type.DATA, bb);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void receive() {
        Reception t = new Reception();
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void receive(String name) {
        Reception t = new Reception();
        t.setReceptionDefaultFileName(name);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void receiveDataObject() {
        Reception t = new Reception(Transfer.Destination.OBJECT);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void receiveDataArray() {
        Reception t = new Reception(Transfer.Destination.ARRAY);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void receiveDataByteBuffer() {
        Reception t = new Reception(Transfer.Destination.BYTEBUFFER);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void receiveDataFile(String name) {
        Reception t = new Reception(Transfer.Destination.FILE);
        t.setReceptionDefaultFileName(name);
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void finishConnection() {
        Shutdown t = new Shutdown();
        this.em.addEvent((Event)new NewTransferEvent(this, (Stage)t));
    }

    public void requestStage(Stage t) {
        LOGGER.info(REQ_TRANSFER + t + MSG_ON_CONNECTION + this.hashCode());
        this.pendingStages.add(t);
        if (this.currentStage == null) {
            LOGGER.debug("Handling next transfer after stage request...");
            this.handleNextTransfer();
        }
    }

    public void established() {
        LOGGER.info(" Connection " + this.hashCode() + " established.");
        if (!this.established) {
            this.established = true;
            if (this.currentStage != null) {
                LOGGER.warn("WARN: Incoherent state in connection " + this.hashCode() + " connection not stablished, but stage is not null. Progressing stage " + this.currentStage.toString());
                this.progressCurrentTransfer();
            } else {
                LOGGER.warn("Connection " + this.hashCode() + " established. Handling next transfer...");
                this.handleNextTransfer();
            }
        } else {
            LOGGER.warn("Accept Event received in connection " + this.hashCode() + " which was already established.");
        }
    }

    public void receivedPacket(ByteBuffer buffer) {
        LOGGER.info(" Connection " + this.hashCode() + " received a packet");
        this.receiveBuffer.add(buffer);
        if (this.currentStage != null) {
            this.progressCurrentTransfer();
        } else {
            LOGGER.warn("WARN: Connection " + this.hashCode() + " received a packet but current stage is null!.");
        }
    }

    public void lowSendBuffer() {
        if (this.currentStage != null && this.currentStage.isSubmission()) {
            this.progressCurrentTransfer();
        }
    }

    public void emptySendBuffer() {
        this.lowSendBuffer();
    }

    public void closedChannel() {
        if (DEBUG) {
            LOGGER.debug("Channel on connection " + this.hashCode() + " has been closed");
        }
        this.closedSocket = true;
        if (this.currentStage != null && !this.paused) {
            NIOException ne = new NIOException(NIOException.SpecificErrorType.CLOSED_CONNECTION, ERROR_CHANNEL_CLOSED + this.hashCode());
            LOGGER.error("Closed Channel Exception", (Throwable)((Object)ne));
            this.currentStage.notifyError((Connection)this, this.em, (CommException)ne);
            LOGGER.debug("Handling next transfer in connection" + this.hashCode() + " because socket closed.");
            this.handleNextTransfer();
        }
        if (this.closedConnection) {
            this.unregisterChannel();
            this.em.connectionFinished((Connection)this);
        }
    }

    public void closeConnection() {
        LOGGER.info("Requesting connection " + this.hashCode() + " closure");
        if (!this.closedSocket) {
            try {
                this.nl.closeSocket(this, this.sc);
            }
            catch (Exception e) {
                LOGGER.error("Exception closing connection " + this.hashCode(), (Throwable)e);
            }
        } else if (!this.closedConnection) {
            this.unregisterChannel();
            this.em.connectionFinished((Connection)this);
        }
        this.closedConnection = true;
        this.handleNextTransfer();
    }

    private void registerChannel(SocketChannel socket) {
        LOGGER.info("Associating Socket: " + socket.hashCode() + MSG_WITH_CONNECTION + this.hashCode());
        this.sc = socket;
    }

    protected void unregisterChannel() {
        LOGGER.info("Unregistering Socket  with connection: " + this.hashCode());
        this.sc = null;
    }

    public void replaceChannel(SocketChannel newSocket) {
        if (DEBUG) {
            if (this.sc == null) {
                LOGGER.debug("Re-Associating Socket: null -> " + newSocket.hashCode() + MSG_WITH_CONNECTION + this.hashCode());
            } else {
                LOGGER.debug("Re-Associating Socket: " + this.sc.hashCode() + " -> " + newSocket.hashCode() + MSG_WITH_CONNECTION + this.hashCode());
            }
        }
        this.sc = newSocket;
    }

    private void pause() {
        LOGGER.info("Transfer " + this.currentStage + MSG_ON_CONNECTION + this.hashCode() + " is paused.");
        this.paused = true;
        this.currentStage.pause((InternalConnection)this);
    }

    public void resume() {
        LOGGER.info("Resume transfer " + this.currentStage + MSG_ON_CONNECTION + this.hashCode());
        this.paused = false;
        this.startCurrentTransfer();
    }

    private void handleNextTransfer() {
        if (this.paused || !this.established) {
            LOGGER.warn("NIOConnection " + this.hashCode() + " not established. Ingnoring handle next transfer request.");
            return;
        }
        if (!this.pendingStages.isEmpty()) {
            this.currentStage = this.pendingStages.removeFirst();
            LOGGER.info(" NIOConnection " + this.hashCode() + " takes " + this.currentStage + " to handle.");
            if (this.currentStage.isShutdown()) {
                LOGGER.info("NIOConnection " + this.hashCode() + " processing shtudown stage " + this.currentStage);
                this.closeConnection();
            } else {
                this.startCurrentTransfer();
            }
        } else {
            LOGGER.warn("NIOConnection " + this.hashCode() + " has no more pending stages to handle.");
            this.currentStage = null;
        }
    }

    protected void startCurrentTransfer() {
        if (this.paused) {
            LOGGER.warn("NIOConnection " + this.hashCode() + " paused.");
            return;
        }
        try {
            boolean isViable = this.currentStage.checkViability(this.closedSocket, this.receiveBuffer, this.sendBuffer);
            if (isViable) {
                LOGGER.info("Starting to process stage " + this.currentStage + " in NIOConnection " + this.hashCode() + " paused.");
                this.currentStage.start((InternalConnection)this, this.receiveBuffer, this.sendBuffer);
                this.progressCurrentTransfer();
            } else {
                LOGGER.warn("NIOConnection " + this.hashCode() + " not viable. Pausing.");
                this.pause();
            }
        }
        catch (ViabilityException ve) {
            LOGGER.error(ERROR_NIO, (Throwable)ve);
            NIOException nioException = new NIOException(NIOException.SpecificErrorType.CLOSED_CONNECTION, ERROR_CHANNEL_CLOSED + this.hashCode(), (Exception)((Object)ve));
            if (this.currentStage != null) {
                this.currentStage.notifyError((Connection)this, this.em, (CommException)nioException);
            }
            this.handleNextTransfer();
        }
        catch (StageException se) {
            LOGGER.error(ERROR_NIO, (Throwable)se);
            if (this.currentStage != null) {
                this.currentStage.notifyError((Connection)this, this.em, (CommException)new NIOException(NIOException.SpecificErrorType.CLOSED_CONNECTION, (Exception)((Object)se)));
            }
            this.handleNextTransfer();
        }
    }

    private void progressCurrentTransfer() {
        if (this.paused) {
            LOGGER.warn("NIOConnection " + this.hashCode() + " paused.");
            return;
        }
        try {
            this.currentStage.progress((InternalConnection)this, this.receiveBuffer, this.sendBuffer);
            if (this.currentStage.isComplete(this.receiveBuffer, this.sendBuffer)) {
                this.currentStage.notifyCompletion((Connection)this, this.em);
                this.handleNextTransfer();
            } else if (this.closedSocket) {
                if (!this.currentStage.checkViability(this.closedSocket, this.receiveBuffer, this.sendBuffer)) {
                    LOGGER.error("Connection closed before completing stage" + this.currentStage + ". Check if a previous error occurred.");
                    NIOException ne = new NIOException(NIOException.SpecificErrorType.CLOSED_CONNECTION, ERROR_CHANNEL_CLOSED + this.hashCode());
                    this.currentStage.notifyError((Connection)this, this.em, (CommException)ne);
                    this.handleNextTransfer();
                }
            } else if (!this.sendBuffer.isEmpty()) {
                LOGGER.warn("Adding Connection " + this.hashCode() + " to selector with write interest in channel " + this.sc.hashCode());
                this.nl.addInterest(this, this.sc, 4);
            }
        }
        catch (StageException e) {
            NIOException ne = new NIOException(NIOException.SpecificErrorType.STAGE, (Exception)((Object)e));
            LOGGER.error(ERROR_NIO, (Throwable)((Object)ne));
            if (this.currentStage != null) {
                this.currentStage.notifyError((Connection)this, this.em, (CommException)ne);
            }
            this.handleNextTransfer();
        }
        catch (ViabilityException e) {
            NIOException ne = new NIOException(NIOException.SpecificErrorType.CLOSED_CONNECTION, (Exception)((Object)e));
            LOGGER.error(ERROR_NIO, (Throwable)((Object)ne));
            if (this.currentStage != null) {
                this.currentStage.notifyError((Connection)this, this.em, (CommException)ne);
            }
            this.handleNextTransfer();
        }
        catch (Exception e) {
            NIOException ne = new NIOException(NIOException.SpecificErrorType.CLOSED_CONNECTION, e);
            LOGGER.error(ERROR_NIO, (Throwable)((Object)ne));
            if (this.currentStage != null) {
                this.currentStage.notifyError((Connection)this, this.em, (CommException)ne);
            }
            this.handleNextTransfer();
        }
    }

    public void error(CommException exception) {
        if (exception.getError().equals((Object)CommException.ErrorType.NIO)) {
            NIOException ne = (NIOException)exception;
            if (ne.getSpecificErrorType() == NIOException.SpecificErrorType.FINISHING_CONNECTION || ne.getSpecificErrorType() == NIOException.SpecificErrorType.STARTING_CONNECTION || ne.getSpecificErrorType() == NIOException.SpecificErrorType.RESTARTING_CONNECTION) {
                LOGGER.warn("Processing recoverable error on connection " + this.hashCode(), (Throwable)exception);
                ++this.conRetries;
                if (this.conRetries < CommProperties.getMaxRetries()) {
                    if (ne.getCause() instanceof SocketTimeoutException) {
                        this.reestablishConnection();
                    } else {
                        if (DEBUG) {
                            LOGGER.debug("Connection " + this.hashCode() + " will try to be reestablish in the future.");
                        }
                        PENDING_ESTABLISH_CONNECTIONS.add(this);
                    }
                } else {
                    LOGGER.error("ERROR: Recoverable error in connection " + this.hashCode() + " and maximum retries is exceeded.", (Throwable)((Object)ne));
                    if (this.currentStage != null) {
                        this.currentStage.notifyError((Connection)this, this.em, exception);
                    }
                    this.closedSocket = true;
                    this.unregisterChannel();
                    this.handleNextTransfer();
                }
            } else {
                LOGGER.error("Unsolvable NIO Error", (Throwable)exception);
                if (this.currentStage != null) {
                    this.currentStage.notifyError((Connection)this, this.em, exception);
                }
                this.handleNextTransfer();
            }
        } else {
            LOGGER.error("Generic COMM Error", (Throwable)exception);
            if (this.currentStage != null) {
                this.currentStage.notifyError((Connection)this, this.em, exception);
            }
            this.handleNextTransfer();
        }
    }

    public static void establishPendingConnections() {
        for (NIOConnection nc : PENDING_ESTABLISH_CONNECTIONS) {
            nc.reestablishConnection();
        }
        PENDING_ESTABLISH_CONNECTIONS.clear();
    }

    private void reestablishConnection() {
        LOGGER.info("Reestablishing connection " + this.hashCode());
        this.nl.restartConnection(this, this.node);
    }

    public static void abortPendingConnections() {
        PENDING_ESTABLISH_CONNECTIONS.clear();
    }

    public List<ByteBuffer> getSendBuffer() {
        return this.sendBuffer;
    }

    public Stage getCurrentTransfer() {
        return this.currentStage;
    }

    public SocketChannel getSocket() {
        return this.sc;
    }
}

