/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.CommProperties;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.MessageHandler;
import es.bsc.comm.Node;
import es.bsc.comm.event.Event;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.NIOListener;
import es.bsc.comm.nio.event.EndEvent;
import es.bsc.comm.nio.event.NIOEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOEventManager
extends EventManager<NIOEvent> {
    private static final Logger LOGGER = LogManager.getLogger((String)"Communication.NIO.EventManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private NIOListener nioListener;
    private boolean nioListenerOn = false;
    private static final long REESTABLISH_PERIOD = 30000L;
    private long lastReestablish;
    private NIOConnection closingConnection;

    public NIOEventManager(MessageHandler receiver) {
        super(receiver);
        LOGGER.debug("Instantiating NIOEventManager");
        this.lastReestablish = System.currentTimeMillis();
    }

    public void init(String propertiesFile) throws CommException {
        LOGGER.info("Initializing NIOEventManager");
        CommProperties.importProperties((String)propertiesFile);
        this.nioListener = new NIOListener();
        this.nioListener.init(this);
    }

    public void startServer(Node n) throws CommException {
        LOGGER.info("Starting server on NIOEventManager");
        this.nioListener.startServer(n);
    }

    public void run() {
        LOGGER.info("Starting NIOListener on NIOEventManager");
        this.nioListener.start();
        this.nioListenerOn = true;
        super.run();
    }

    protected final void specificActions() {
        long now = System.currentTimeMillis();
        if (this.lastReestablish + 30000L > now) {
            return;
        }
        this.lastReestablish = now;
        NIOConnection.establishPendingConnections();
    }

    protected void handleSpecificStop() {
        LOGGER.debug("NIOEventManager handle specific stop");
        this.nioListener.shutdown(this.closingConnection);
        while (this.nioListenerOn) {
            this.processEvent();
        }
    }

    protected final void logProcessingEvent(Event e) {
        if (e instanceof NIOEvent) {
            NIOEvent ne = (NIOEvent)e;
            if (DEBUG) {
                LOGGER.debug("Processing " + (Object)((Object)ne.getEventType()) + " NIOEvent");
            }
        }
    }

    protected NIOEvent createEndEvent() {
        return new EndEvent(null);
    }

    public Connection startConnection(Node n) {
        return this.nioListener.startConnection(n);
    }

    public void shutdown(Connection c) {
        LOGGER.info("Shutting down the communication platform");
        this.closingConnection = (NIOConnection)c;
        super.shutdown();
    }

    public void listenerStopped() {
        this.nioListenerOn = false;
        this.addEvent(this.createEndEvent());
    }
}

