/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.CommProperties;
import es.bsc.comm.Node;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.nio.NIOServerConnection;
import es.bsc.comm.nio.event.ClosedChannelEvent;
import es.bsc.comm.nio.event.ConnectionEstablished;
import es.bsc.comm.nio.event.EmptyBufferEvent;
import es.bsc.comm.nio.event.ErrorEvent;
import es.bsc.comm.nio.event.LowBufferEvent;
import es.bsc.comm.nio.event.PacketEntry;
import es.bsc.comm.nio.exceptions.NIOException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOListener
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger((String)"Communication.NIO.Listener");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String DEFAULT_ADDRESS_IP = "127.0.0.1";
    private static final long SELECTOR_SLEEP = 100L;
    private static final int BACK_LOG = 7000;
    private Map<Integer, ServerSocketChannel> servers;
    private Set<SocketChannel> openChannels;
    private BlockingQueue<ChangeRequest> pendingChanges;
    private Map<SocketChannel, ChangeRequest> pendingInterests;
    private volatile boolean stop = false;
    private NIOConnection closingConnection;
    private Selector selector;
    private NIOEventManager eventManager;
    private static Object lock = new Object();

    public NIOListener() {
        super("NIOListener");
        LOGGER.info("Instantiating NIOListener");
        this.servers = new HashMap<Integer, ServerSocketChannel>();
        this.openChannels = new HashSet<SocketChannel>();
        this.pendingChanges = new LinkedBlockingQueue<ChangeRequest>();
        this.pendingInterests = new HashMap<SocketChannel, ChangeRequest>();
    }

    public final void init(NIOEventManager nem) throws NIOException {
        LOGGER.info("Initializing NIOListener");
        try {
            this.selector = SelectorProvider.provider().openSelector();
        }
        catch (Exception e) {
            throw new NIOException(NIOException.SpecificErrorType.LOADING_LISTENER, e);
        }
        this.eventManager = nem;
    }

    public final void startServer(Node n) throws NIOException {
        LOGGER.info("Starting server on NIOListener");
        NIONode nn = (NIONode)n;
        String ip = nn.getIp();
        int port = nn.getPort();
        try {
            ServerSocketChannel ssc = this.configureServerSocketChannel();
            this.servers.put(port, ssc);
            InetSocketAddress inet = ip == null ? new InetSocketAddress(port) : new InetSocketAddress(ip, port);
            ssc.socket().bind(inet, 7000);
            ChangeRequest cr = new ChangeRequest(null, ssc, 16, false);
            this.addChangeRequest(cr);
        }
        catch (Exception e) {
            LOGGER.error("Exception starting server", (Throwable)e);
            throw new NIOException(NIOException.SpecificErrorType.STARTING_SERVER, e);
        }
    }

    @Override
    public final void run() {
        LOGGER.info("NIOListener started");
        while (!this.stop) {
            try {
                this.applyInterestChanges();
                int keys = this.selector.select();
                if (keys == 0) continue;
                LOGGER.warn("Selected " + keys + "keys.");
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                this.processKeys(selectedKeys);
            }
            catch (Exception e) {
                LOGGER.error("Error listening on connection changes", (Throwable)e);
            }
        }
        LOGGER.info("Closing all connections " + (this.closingConnection != null ? "but " + this.closingConnection : ""));
        this.closeServers();
        this.closeConnections();
        this.waitUntilAllChannelsClosed();
        LOGGER.debug("Notifying closure to Event Manager");
        this.eventManager.listenerStopped();
        LOGGER.info("NIOListener stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(NIOConnection connection) {
        LOGGER.warn("Shutdown received on NIOListener");
        this.stop = true;
        this.closingConnection = connection;
        Object object = lock;
        synchronized (object) {
            LOGGER.warn("Wake up selector in shutdown");
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addChangeRequest(ChangeRequest cr) throws Exception {
        if (!this.pendingChanges.offer(cr)) {
            LOGGER.error("ERROR in Comm NIOListener. ChangeRequest [Type:" + cr.type + ", Conn: " + cr.connection.hashCode() + " SC: " + cr.channel.hashCode() + " has not been added to the pending request queue! Message Lost ");
        }
        Object object = lock;
        synchronized (object) {
            LOGGER.warn("Wake up selector");
            this.selector.wakeup();
        }
    }

    private ServerSocketChannel configureServerSocketChannel() throws IOException {
        NetworkChannel ssc = ServerSocketChannel.open();
        ((AbstractSelectableChannel)((Object)ssc)).configureBlocking(false);
        ssc = ((ServerSocketChannel)ssc).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        ((ServerSocketChannel)ssc).socket().setReuseAddress(true);
        return ssc;
    }

    private SocketChannel configureSocketChannel(SocketChannel sc) throws Exception {
        ((AbstractSelectableChannel)((Object)sc)).configureBlocking(false);
        sc = ((SocketChannel)sc).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        sc = ((SocketChannel)sc).setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
        sc = ((SocketChannel)sc).setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        ((SocketChannel)sc).socket().setTcpNoDelay(true);
        return sc;
    }

    private void closeServers() {
        for (Map.Entry<Integer, ServerSocketChannel> activeServer : this.servers.entrySet()) {
            Integer port = activeServer.getKey();
            ServerSocketChannel ssc = activeServer.getValue();
            try {
                if (DEBUG) {
                    LOGGER.debug("Closing server connection on port " + port);
                }
                ssc.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Error closing server connection on port " + port, (Throwable)ioe);
            }
        }
    }

    private void closeConnections() {
        SocketChannel[] socketChanels;
        NIOConnection.abortPendingConnections();
        SocketChannel[] socketChannelArray = socketChanels = this.openChannels.toArray(new SocketChannel[this.openChannels.size()]);
        int n = socketChanels.length;
        int n2 = 0;
        while (n2 < n) {
            SocketChannel sc = socketChannelArray[n2];
            if (this.closingConnection == null || this.closingConnection.getSocket() != sc) {
                if (sc.isConnected()) {
                    if (DEBUG) {
                        LOGGER.debug("Close channel " + sc.hashCode() + " from closeConnections");
                    }
                } else {
                    LOGGER.warn("Channel " + sc.hashCode() + " is not connected");
                }
                SelectionKey key = sc.keyFor(this.selector);
                this.closeChannel(key, sc);
            }
            ++n2;
        }
    }

    private void closeChannel(SelectionKey key, SocketChannel sc) {
        if (key != null) {
            LOGGER.warn("Cancelling key for channel " + sc.hashCode());
            key.cancel();
        }
        this.openChannels.remove(sc);
        if (sc.isOpen()) {
            if (DEBUG) {
                LOGGER.debug("Channel " + sc.hashCode() + "is open. Requesting closure");
            }
            if (key != null) {
                NIOConnection nc = (NIOConnection)key.attachment();
                this.eventManager.addEvent(new ClosedChannelEvent(nc));
            }
            try {
                LOGGER.warn("Clossing channel " + sc.hashCode());
                sc.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close channel " + sc, (Throwable)e);
            }
        }
    }

    private void waitUntilAllChannelsClosed() {
        while (!this.openChannels.isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("Waiting for closing connection changes");
                StringBuilder sb = new StringBuilder("Alive channels: ");
                for (SocketChannel s : this.openChannels) {
                    sb.append(s.hashCode()).append(" ");
                }
                LOGGER.debug(sb.toString());
            }
            try {
                this.applyInterestChanges();
                this.selector.select(100L);
                this.processKeys(this.selector.selectedKeys().iterator());
            }
            catch (Exception e) {
                LOGGER.warn("Error listening on closing connection changes", (Throwable)e);
            }
        }
    }

    public final void closeSocket(NIOConnection nc, SocketChannel sc) throws Exception {
        ChangeRequest cr = new ChangeRequest(nc, sc, 0, true);
        this.addChangeRequest(cr);
    }

    public final void addInterest(NIOConnection nc, SocketChannel sc, int key) throws Exception {
        ChangeRequest cr = new ChangeRequest(nc, sc, key, false);
        this.addChangeRequest(cr);
    }

    public final NIOConnection startConnection(Node targetNode) {
        NIONode n = (NIONode)targetNode;
        NIOConnection nc = null;
        try {
            SocketChannel sc = SocketChannel.open();
            sc = this.configureSocketChannel(sc);
            InetSocketAddress inet = n.getIp() == null ? new InetSocketAddress(DEFAULT_ADDRESS_IP, n.getPort()) : new InetSocketAddress(n.getIp(), n.getPort());
            sc.connect(inet);
            nc = new NIOConnection(this.eventManager, this, sc, n);
            ChangeRequest cr = new ChangeRequest(nc, sc, 8, false);
            this.addChangeRequest(cr);
        }
        catch (Exception e) {
            LOGGER.error("Error starting connection", (Throwable)e);
            NIOException ne = new NIOException(NIOException.SpecificErrorType.STARTING_CONNECTION, e);
            nc = new NIOConnection(this.eventManager, this, null, n);
            this.eventManager.addEvent(new ErrorEvent(nc, ne));
        }
        return nc;
    }

    public final void restartConnection(NIOConnection nc, NIONode targetNode) {
        try {
            SocketChannel sc = SocketChannel.open();
            sc = this.configureSocketChannel(sc);
            InetSocketAddress inet = targetNode.getIp() == null ? new InetSocketAddress(DEFAULT_ADDRESS_IP, targetNode.getPort()) : new InetSocketAddress(targetNode.getIp(), targetNode.getPort());
            sc.connect(inet);
            nc.replaceChannel(sc);
            ChangeRequest cr = new ChangeRequest(nc, sc, 8, false);
            this.addChangeRequest(cr);
        }
        catch (Exception e) {
            LOGGER.error("Error replacing connection", (Throwable)e);
            NIOException ne = new NIOException(NIOException.SpecificErrorType.RESTARTING_CONNECTION, e);
            this.eventManager.addEvent(new ErrorEvent(nc, ne));
        }
    }

    private void applyInterestChanges() throws Exception {
        LOGGER.debug("* Applying interest changes");
        while (!this.pendingChanges.isEmpty()) {
            ChangeRequest change = (ChangeRequest)this.pendingChanges.poll();
            this.registerChange(change);
        }
        LOGGER.debug(" * Applied Interest Changes");
    }

    private void registerChange(ChangeRequest change) throws Exception {
        try {
            if (change.close) {
                SocketChannel sc = (SocketChannel)change.channel;
                SelectionKey key = sc.keyFor(this.selector);
                if (DEBUG) {
                    LOGGER.debug("Closing channel " + sc.hashCode() + " no more data to write");
                }
                this.closeChannel(key, sc);
            } else if (change.type != 16) {
                SocketChannel sc = (SocketChannel)change.channel;
                if (!sc.isConnected() && change.type != 8) {
                    LOGGER.warn("Channel " + sc.hashCode() + " not connected and requesting change to " + change.type + " different from " + 8);
                    this.pendingInterests.put(sc, change);
                } else if (sc.isOpen()) {
                    LOGGER.warn("Registering interest " + change.type + " for channel " + sc.hashCode());
                    SelectionKey key = ((SelectableChannel)change.channel).register(this.selector, change.type);
                    if (!key.isValid()) {
                        LOGGER.warn("Key for Channel " + sc.hashCode() + " operation " + change.type + " not valid.");
                    }
                    key.attach(change.connection);
                    if (change.type == 4) {
                        sc.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)CommProperties.getNetworkBufferSize());
                    }
                } else {
                    LOGGER.warn("Channel " + sc.hashCode() + " is not open!");
                }
            } else {
                SelectionKey key = ((SelectableChannel)change.channel).register(this.selector, change.type);
                if (!key.isValid()) {
                    LOGGER.warn("Key for Channel " + change.channel.hashCode() + " operation " + change.type + " not valid.");
                }
                key.attach(change.connection);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception registering change for connection " + change.connection.hashCode() + " and channel " + change.channel.hashCode(), (Throwable)e);
        }
    }

    private void processKeys(Iterator<SelectionKey> selectedKeys) throws Exception {
        LOGGER.debug(" * Processing Keys");
        int keys = 0;
        while (selectedKeys.hasNext()) {
            ++keys;
            SelectionKey key = selectedKeys.next();
            selectedKeys.remove();
            if (!key.isValid()) {
                LOGGER.warn("WARN: Invalid Key for " + key.channel().hashCode());
                key.cancel();
                continue;
            }
            if (key.isAcceptable()) {
                this.accept(key);
                continue;
            }
            if (key.isConnectable()) {
                this.connect(key);
                continue;
            }
            if (key.isReadable()) {
                this.read(key);
                continue;
            }
            if (key.isWritable()) {
                this.write(key);
                continue;
            }
            LOGGER.warn(" WARN: Undefined key type for " + key.channel().hashCode());
        }
        LOGGER.debug(" * " + keys + " Keys Processed");
    }

    private void accept(SelectionKey key) {
        LOGGER.warn(" - Accepting key for channel" + key.channel().hashCode());
        try {
            ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
            SocketChannel sc = ssc.accept();
            sc = this.configureSocketChannel(sc);
            this.openChannels.add(sc);
            String address = sc.socket().getInetAddress().getHostAddress();
            int port = sc.socket().getPort();
            NIONode n = new NIONode(address, port);
            NIOServerConnection nc = new NIOServerConnection(this.eventManager, this, sc, n);
            ChangeRequest cr = new ChangeRequest(nc, sc, 1, false);
            this.addChangeRequest(cr);
            ConnectionEstablished ce = new ConnectionEstablished(nc);
            this.eventManager.addEvent(ce);
        }
        catch (Exception e) {
            LOGGER.error("Error accepting connection", (Throwable)e);
            NIOException ne = new NIOException(NIOException.SpecificErrorType.ACCEPTING_CONNECTION, e);
            this.eventManager.addEvent(new ErrorEvent(ne));
            key.cancel();
        }
        LOGGER.debug(" - Accepted ");
    }

    private void connect(SelectionKey key) {
        LOGGER.debug(" - Connect ");
        SocketChannel sc = (SocketChannel)key.channel();
        this.openChannels.add(sc);
        NIOConnection nc = (NIOConnection)key.attachment();
        try {
            if (sc.finishConnect()) {
                this.acceptedConnection(nc, sc);
            } else {
                LOGGER.error("Refused connection cancelling key for channel " + sc.hashCode());
                this.refusedConnection(nc, sc, null);
                key.cancel();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing connect", (Throwable)e);
            this.refusedConnection(nc, sc, e);
            key.cancel();
        }
        LOGGER.debug(" - Connected ");
    }

    private void acceptedConnection(NIOConnection nc, SocketChannel sc) throws Exception {
        ChangeRequest cr = this.pendingInterests.get(sc);
        if (cr == null && this.pendingChanges.isEmpty()) {
            cr = new ChangeRequest(nc, sc, 1, false);
        }
        if (cr != null) {
            this.addChangeRequest(cr);
        }
        ConnectionEstablished ce = new ConnectionEstablished(nc);
        this.eventManager.addEvent(ce);
    }

    private void refusedConnection(NIOConnection nc, SocketChannel sc, Exception e) {
        this.pendingInterests.remove(sc);
        NIOException ne = new NIOException(NIOException.SpecificErrorType.FINISHING_CONNECTION, e);
        ErrorEvent ee = new ErrorEvent(nc, ne);
        this.eventManager.addEvent(ee);
        try {
            LOGGER.warn("Closing socket " + sc.hashCode() + " because ");
            sc.close();
        }
        catch (Exception ioe) {
            LOGGER.error("Exception in refused connection " + nc.hashCode(), (Throwable)ioe);
            NIOException ne2 = new NIOException(NIOException.SpecificErrorType.FINISHING_CONNECTION, ioe);
            ErrorEvent ee2 = new ErrorEvent(nc, ne2);
            this.eventManager.addEvent(ee2);
        }
    }

    private void read(SelectionKey key) {
        LOGGER.debug(" - Read ");
        SocketChannel sc = (SocketChannel)key.channel();
        NIOConnection nc = (NIOConnection)key.attachment();
        try {
            ByteBuffer readBuffer = ByteBuffer.allocate(CommProperties.getPacketSize());
            int size = sc.read(readBuffer);
            if (size == -1) {
                this.closeChannel(key, sc);
                return;
            }
            readBuffer.flip();
            PacketEntry p = new PacketEntry(nc, readBuffer);
            this.eventManager.addEvent(p);
        }
        catch (Exception ioe) {
            LOGGER.error("Exception reading key in channel " + sc.hashCode() + " in connection " + nc.hashCode(), (Throwable)ioe);
            NIOException ne = new NIOException(NIOException.SpecificErrorType.READ, ioe);
            this.eventManager.addEvent(new ErrorEvent(nc, ne));
            this.closeChannel(key, sc);
        }
        LOGGER.debug(" - Readed ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void write(SelectionKey key) throws Exception {
        sc = (SocketChannel)key.channel();
        nc = (NIOConnection)key.attachment();
        NIOListener.LOGGER.debug("--- Begin write in connection" + nc.hashCode());
        sendBuffer = (LinkedList)nc.getSendBuffer();
        if (!sendBuffer.isEmpty()) ** GOTO lbl62
        if (nc.getCurrentTransfer() != null) {
            NIOListener.LOGGER.debug("Requesting to change interest to READ because of EMPTY BUFFER in Connection " + nc.hashCode());
            cr = new ChangeRequest(nc, sc, 1, false);
            this.addChangeRequest(cr);
            this.eventManager.addEvent(new EmptyBufferEvent(nc));
        }
        return;
lbl-1000:
        // 1 sources

        {
            var6_7 = sendBuffer;
            synchronized (var6_7) {
                writeBuffer = (ByteBuffer)sendBuffer.getFirst();
            }
            if (writeBuffer == null) continue;
            try {
                if (writeBuffer.remaining() > 0) {
                    if (NIOListener.DEBUG) {
                        NIOListener.LOGGER.debug("writting buffer" + writeBuffer.hashCode() + " of socket " + sc.hashCode() + " in connection " + nc.hashCode());
                    }
                    written = sc.write(writeBuffer);
                    if (NIOListener.DEBUG) {
                        NIOListener.LOGGER.debug(String.valueOf(written) + " bytes written to socket " + sc.hashCode() + " in connection " + nc.hashCode());
                    }
                    if (written <= 0) {
                        if (NIOListener.DEBUG) {
                            NIOListener.LOGGER.debug("Nothing written in socket " + sc.hashCode() + " in connection " + nc.hashCode() + ". Stopping to write");
                        }
                        return;
                    }
                }
            }
            catch (Exception e) {
                NIOListener.LOGGER.error("Error writting key in channel " + sc.hashCode() + " connection " + nc.hashCode() + ". Closing Channel " + sc.hashCode(), (Throwable)e);
                ne /* !! */  = new NIOException(NIOException.SpecificErrorType.WRITE, e);
                this.eventManager.addEvent(new ErrorEvent(nc, (CommException)ne /* !! */ ));
                this.closeChannel(key, sc);
                return;
            }
            if (writeBuffer.remaining() != 0) continue;
            if (NIOListener.DEBUG) {
                NIOListener.LOGGER.debug("Removed buffer" + writeBuffer.hashCode() + " of socket " + sc.hashCode() + " in connection " + nc.hashCode());
            }
            count = -1;
            ne /* !! */  = sendBuffer;
            synchronized (ne /* !! */ ) {
                sendBuffer.removeFirst();
                count = sendBuffer.size();
            }
            if (count == 0) {
                if (NIOListener.DEBUG) {
                    NIOListener.LOGGER.debug("Requesting to change interest of socket " + sc.hashCode() + " to READ ( " + 1 + ") because of EMPTY BUFFER in Connection " + nc.hashCode());
                }
                cr = new ChangeRequest(nc, sc, 1, false);
                this.addChangeRequest(cr);
                this.eventManager.addEvent(new EmptyBufferEvent(nc));
                continue;
            }
            if (count != CommProperties.getMinBufferedPackets()) continue;
            if (NIOListener.DEBUG) {
                NIOListener.LOGGER.debug("Sending Low Buffer Event to Connection " + nc.hashCode());
            }
            this.eventManager.addEvent(new LowBufferEvent(nc));
lbl62:
            // 6 sources

            ** while (!sendBuffer.isEmpty())
        }
lbl63:
        // 1 sources

        NIOListener.LOGGER.debug("--- End write connection " + nc.hashCode());
    }

    private static class ChangeRequest {
        private final NIOConnection connection;
        private final Channel channel;
        private final int type;
        private final boolean close;

        public ChangeRequest(NIOConnection nc, Channel socket, int type, boolean close) {
            this.connection = nc;
            this.channel = socket;
            this.type = type;
            this.close = close;
        }
    }
}

