/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIOListener;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.stage.Reception;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOServerConnection
extends NIOConnection {
    private static final Logger LOGGER = LogManager.getLogger((String)"Communication.NIO.Connection");
    private boolean uselessConnection = true;

    public NIOServerConnection(NIOEventManager ntm, NIOListener nl, SocketChannel sc, NIONode n) {
        super(ntm, nl, sc, n);
    }

    @Override
    public void receivedPacket(ByteBuffer buffer) {
        if (this.uselessConnection) {
            this.uselessConnection = false;
            this.currentStage = new Reception(false);
            this.startCurrentTransfer();
        }
        super.receivedPacket(buffer);
    }

    @Override
    public void closedChannel() {
        if (this.uselessConnection) {
            LOGGER.debug("Closing useless server connection " + this);
            this.unregisterChannel();
        } else {
            super.closedChannel();
        }
    }
}

