/*
 * Decompiled with CFR 0.152.
 */
package cbm2.objects;

import cbm2.objects.Cbm2Impl;
import cbm2.objects.DummyPayload;

public class Cbm2 {
    private static void usage() {
        System.out.println(":::: Usage: runcompss cbm2.objects.Cbm2 (num_Tasks) (deepness) (task_Sleep_Time) (txSizeInBytes) (INOUT | IN):::: ");
        System.out.println("Exiting cbm2...!");
    }

    public static void main(String[] args) {
        int i;
        if (args.length < 5 || !args[4].equals("INOUT") && !args[4].equals("IN")) {
            Cbm2.usage();
            return;
        }
        int numTasks = Integer.parseInt(args[0]);
        int deepness = Integer.parseInt(args[1]);
        int taskSleepTime = Integer.parseInt(args[2]);
        int txSizeInBytes = Integer.parseInt(args[3]);
        boolean inout = args[4].equals("INOUT");
        System.out.println(":::::::::::");
        System.out.println("Number of tasks: {{" + numTasks + "}}");
        System.out.println("Deps graph deepness: {{" + deepness + "}}");
        System.out.println("Tasks sleep time: {{" + taskSleepTime + "}}");
        System.out.println("Transference size in bytes: {{" + txSizeInBytes + "}}");
        System.out.println("Execution type (INOUT || IN): {{" + (inout ? "INOUT" : "IN") + "}}");
        System.out.println("Execution type (FILES || OBJECTS): {{OBJECTS}}");
        System.out.println(":::::::::::");
        System.out.println("");
        System.out.println(":::::::::::");
        System.out.println("Starting cbm2 with objects...");
        double compssTime = System.nanoTime();
        System.out.println("Creating pool of objects...");
        DummyPayload[] dummyObjects = new DummyPayload[numTasks];
        for (int i2 = 0; i2 < numTasks; ++i2) {
            dummyObjects[i2] = new DummyPayload(txSizeInBytes);
        }
        System.out.println("Pool of objects created.");
        System.out.println("Time for objects to be created: " + ((double)System.nanoTime() - compssTime) / 1000000.0 + " ms");
        System.out.println("Starting to measure time from now on...");
        compssTime = System.nanoTime();
        System.out.println("Creating tasks...");
        for (int d = 1; d <= deepness; ++d) {
            for (i = 0; i < numTasks; ++i) {
                if (inout) {
                    Cbm2Impl.runTaskInOut(taskSleepTime, dummyObjects[i]);
                    continue;
                }
                dummyObjects[i] = Cbm2Impl.runTaskIn(taskSleepTime, dummyObjects[i]);
            }
        }
        System.out.println("Finished creating tasks...");
        boolean startedGettingObjects = false;
        for (i = 0; i < numTasks; ++i) {
            dummyObjects[i].foo();
            if (!startedGettingObjects) {
                startedGettingObjects = true;
                System.out.println("Started getting objects...");
            }
            System.out.println("Got object " + i);
        }
        compssTime = ((double)System.nanoTime() - compssTime) / 1000000.0;
        System.out.println("Finished cbm2!!!");
        System.out.println(":::::::::::");
        System.out.println("");
        System.out.println(":::::::::::");
        System.out.println("Results:");
        System.out.println("Time: " + compssTime + " ms    ({{" + compssTime + "}})");
        System.out.println(":::::::::::");
    }
}

