/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.cbm3.files;

import es.bsc.compss.cbm3.files.Cbm3Impl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class Cbm3 {
    private static void usage() {
        System.out.println(":::: Usage: runcompss cbm3.files.Cbm3 (deepness) (task_Sleep_Time) (txSizeInBytes) (INOUT | IN) ::::");
        System.out.println("Exiting cbm3...!");
    }

    public static void main(String[] args) {
        if (args.length < 4 || !args[3].equals("INOUT") && !args[3].equals("IN")) {
            Cbm3.usage();
            return;
        }
        int deepness = Integer.parseInt(args[0]);
        int taskSleepTime = Integer.parseInt(args[1]);
        int txSizeInBytes = Integer.parseInt(args[2]);
        boolean inout = args[3].equals("INOUT");
        System.out.println(":::::::::::");
        System.out.println("Dependency graph deepness: {{" + deepness + "}}");
        System.out.println("Tasks sleep time: {{" + taskSleepTime + "}}");
        System.out.println("Transference size in bytes: {{" + txSizeInBytes + "}}");
        System.out.println("Execution type (INOUT || IN): {{" + (inout ? "INOUT" : "IN") + "}}");
        System.out.println("Execution type (FILES || OBJECTS): {{FILES}}");
        System.out.println(":::::::::::");
        System.out.println("");
        System.out.println(":::::::::::");
        System.out.println("Starting cbm3 with files...");
        System.out.println("Creating pool of files...");
        int numTasks = (int)Math.pow(2.0, ++deepness - 1);
        String[] dummyFilePaths = new String[numTasks];
        for (int i = 0; i < numTasks; ++i) {
            try {
                String filePath;
                dummyFilePaths[i] = filePath = "dummyFile_Task" + String.valueOf(i);
                FileOutputStream fos = new FileOutputStream(filePath);
                byte[] dummyLoad = new byte[txSizeInBytes];
                new Random().nextBytes(dummyLoad);
                fos.write(dummyLoad);
                fos.close();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        System.out.println("Pool of files created (" + dummyFilePaths.length + " created)");
        System.out.println("From now on we start to measure time...");
        System.out.println("Creating tasks...");
        double compssTime = System.nanoTime();
        int step = 1;
        for (int d = 0; d <= deepness; ++d) {
            int i = 0;
            while (i + step < numTasks) {
                if (inout) {
                    Cbm3Impl.runTaskInOut(taskSleepTime, dummyFilePaths[i], dummyFilePaths[i + step]);
                } else {
                    Cbm3Impl.runTaskIn(taskSleepTime, dummyFilePaths[i], dummyFilePaths[i + step], dummyFilePaths[i]);
                }
                i += step * 2;
            }
            step *= 2;
        }
        System.out.println("Tasks created in " + ((double)System.nanoTime() - compssTime) / 1000000.0 + " ms");
        System.out.println("Waiting to sync...");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(dummyFilePaths[0]));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("Got file \"" + dummyFilePaths[0] + "\"");
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println(":::::::::::");
        System.out.println("cbm3 Finished!");
        System.out.println("Time: {{" + ((double)System.nanoTime() - compssTime) / 1000000.0 + "}}");
        System.out.println(":::::::::::");
    }
}

