/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.cbm3.objects;

import es.bsc.compss.cbm3.objects.Cbm3Impl;
import es.bsc.compss.cbm3.objects.DummyPayload;

public class Cbm3 {
    private static void usage() {
        System.out.println(":::: Usage: runcompss cbm3.objects.Cbm3 (deepness) (task_Sleep_Time) (txSizeInBytes) (INOUT | IN)::::");
        System.out.println("Exiting cbm3...!");
    }

    public static void main(String[] args) {
        if (args.length < 4 || !args[3].equals("INOUT") && !args[3].equals("IN")) {
            Cbm3.usage();
            return;
        }
        int deepness = Integer.parseInt(args[0]);
        int taskSleepTime = Integer.parseInt(args[1]);
        int txSizeInBytes = Integer.parseInt(args[2]);
        boolean inout = args[3].equals("INOUT");
        System.out.println(":::::::::::");
        System.out.println("Dependency graph deepness: {{" + deepness + "}}");
        System.out.println("Tasks sleep time: {{" + taskSleepTime + "}}");
        System.out.println("Transference size in bytes: {{" + txSizeInBytes + "}}");
        System.out.println("Execution type (INOUT || IN): {{" + (inout ? "INOUT" : "IN") + "}}");
        System.out.println("Execution type (FILES || OBJECTS): {{OBJECTS}}");
        System.out.println(":::::::::::");
        System.out.println("");
        System.out.println(":::::::::::");
        System.out.println("Starting cbm3 with objects...");
        System.out.println("Creating pool of objects...");
        int numTasks = (int)Math.pow(2.0, ++deepness - 1);
        DummyPayload[] dummyPool = new DummyPayload[numTasks];
        for (int i = 0; i < numTasks; ++i) {
            dummyPool[i] = new DummyPayload(txSizeInBytes);
        }
        System.out.println("Pool of objects created (" + dummyPool.length + " created)");
        System.out.println("From now on we start to measure time...");
        System.out.println("Creating tasks...");
        double compssTime = System.nanoTime();
        int step = 1;
        for (int d = 0; d <= deepness; ++d) {
            int i = 0;
            while (i + step < numTasks) {
                DummyPayload obj = dummyPool[i];
                if (inout) {
                    Cbm3Impl.runTaskInOut(taskSleepTime, dummyPool[i], dummyPool[i + step]);
                } else {
                    dummyPool[i] = obj = Cbm3Impl.runTaskIn(taskSleepTime, obj, dummyPool[i + step]);
                }
                i += step * 2;
            }
            step *= 2;
        }
        System.out.println("Tasks created in " + ((double)System.nanoTime() - compssTime) / 1000000.0 + " ms");
        System.out.println("Waiting to sync...");
        System.out.println("Sync: " + dummyPool[0]);
        System.out.println(":::::::::::");
        System.out.println("cbm3 Finished!");
        System.out.println("Time: {{" + ((double)System.nanoTime() - compssTime) / 1000000.0 + "}}");
        System.out.println(":::::::::::");
    }
}

