/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm.messages.types;

import es.bsc.compss.agent.comm.messages.types.CommParam;
import es.bsc.compss.agent.types.ApplicationParameterCollection;
import es.bsc.compss.nio.NIOParam;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

public class CommParamCollection
extends CommParam
implements ApplicationParameterCollection<CommParam>,
Externalizable {
    private List<CommParam> collectionParameters;

    public CommParamCollection() {
    }

    public CommParamCollection(CommParam p) {
        super(p);
        this.collectionParameters = new LinkedList<CommParam>();
    }

    public int getSize() {
        return this.collectionParameters.size();
    }

    public List<CommParam> getCollectionParameters() {
        return this.collectionParameters;
    }

    public void addParameter(CommParam p) {
        this.collectionParameters.add(p);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.collectionParameters = new LinkedList<CommParam>();
        int numParameters = in.readInt();
        for (int i = 0; i < numParameters; ++i) {
            this.collectionParameters.add((CommParam)in.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.collectionParameters.size());
        for (NIOParam nIOParam : this.collectionParameters) {
            out.writeObject(nIOParam);
        }
    }

    @Override
    protected void dumpInternalInfo(StringBuilder sb) {
        sb.append("\"elements\":[");
        for (CommParam p : this.collectionParameters) {
            sb.append(p.toString() + ",");
        }
        sb.append("],");
        super.dumpInternalInfo(sb);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.dumpInternalInfo(sb);
        sb.append("}");
        return sb.toString();
    }
}

