/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.util.TraceEventType;
import es.bsc.compss.util.types.PrvHeader;
import es.bsc.compss.util.types.PrvLine;
import es.bsc.compss.util.types.RowFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TraceMerger {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final Integer SYNC_TYPE = TraceEventType.SYNC.code;
    private static final String SYNC_REGEX = "(^\\d+:\\d+:\\d+):(\\d+):(\\d+):(\\d+).*:" + SYNC_TYPE + ":(\\d+)";
    private static final Pattern SYNC_PATTERN = Pattern.compile(SYNC_REGEX);
    private static final Integer R_ID_INDEX = 1;
    private static final Integer TIMESTAMP_INDEX = 4;
    private static final Integer WORKER_ID_INDEX = 2;
    private static final Integer VALUE_INDEX = 5;
    private static final String WORKER_THREAD_INFO_REGEX = "(^\\d+):(\\d+):(\\d+):(\\d+):(\\d+):(\\d+):(.*)";
    private static final Pattern WORKER_THREAD_INFO_PATTERN = Pattern.compile("(^\\d+):(\\d+):(\\d+):(\\d+):(\\d+):(\\d+):(.*)");
    private static final Integer STATE_TYPE = 1;
    private static final Integer WORKER_THREAD_ID = 2;
    private static final Integer WORKER_TIMESTAMP = 6;
    private static final Integer WORKER_LINE_INFO = 7;
    private static final String TASKS_FUNC_TYPE_STRING = Integer.toString(TraceEventType.TASKS_FUNC.code);
    private static final String CE_FIXED_COUNTER = "0    " + TASKS_FUNC_TYPE_STRING + "    Task";
    private static final String CE_ID_VALUE_SEPARATOR = "      ";
    private static final String COUNTER_HEADER = "EVENT_TYPE";
    private static final String HW_FIXED_COUNTER = "7  41999999 Active hardware counter set";
    private static final String HW_COUNTER_LINE_HEADER = "7  4200";
    private File masterTrace;
    private String masterTracePath;
    private String masterTracePcfPath;
    private String masterTraceRowPath;
    private File[] workersTraces;
    private String[] workersTracePath;
    private String[] workersTracePcfPath;
    private String[] workersTraceRowPath;
    private PrintWriter masterWriter;
    private PrintWriter masterPcfWriter;

    protected void setUpMaster(File masterTrace) throws IOException {
        if (masterTrace == null || !masterTrace.exists()) {
            throw new FileNotFoundException("Master trace not found.");
        }
        this.masterTrace = masterTrace;
        this.masterTracePath = this.masterTrace.getAbsolutePath();
        this.masterTracePcfPath = this.masterTracePath.replace(".prv", ".pcf");
        this.masterTraceRowPath = this.masterTracePath.replace(".prv", ".row");
        this.masterWriter = new PrintWriter(new FileWriter(this.masterTracePath, true));
        this.masterPcfWriter = new PrintWriter(new FileWriter(this.masterTracePcfPath, true));
    }

    protected void setUpWorkers(File[] workersTraces) throws IOException {
        this.workersTraces = workersTraces;
        if (this.workersTraces == null || this.workersTraces.length == 0) {
            throw new FileNotFoundException("No workers traces to merge found.");
        }
        this.workersTracePath = new String[this.workersTraces.length];
        this.workersTracePcfPath = new String[this.workersTraces.length];
        this.workersTraceRowPath = new String[this.workersTraces.length];
        for (int i = 0; i < this.workersTracePath.length; ++i) {
            this.workersTracePath[i] = this.workersTraces[i].getAbsolutePath();
            this.workersTracePcfPath[i] = this.workersTracePath[i].replace(".prv", ".pcf");
            this.workersTraceRowPath[i] = this.workersTracePath[i].replace(".prv", ".row");
        }
    }

    protected void mergePRVsWithTraceNumAndSyncEvents() throws Exception {
        LOGGER.debug("Parsing master sync events");
        Map<Integer, List<LineInfo>> masterSyncEvents = this.getSyncEvents(this.masterTracePath, -1);
        LOGGER.debug("Merging task traces into master which contains " + masterSyncEvents.size() + " lines.");
        for (File workerFile : this.workersTraces) {
            Integer workerID;
            LOGGER.debug("Merging worker " + workerFile);
            String workerFileName = workerFile.getName();
            String wID = "";
            int i = 0;
            while (workerFileName.charAt(i) != '_') {
                wID = wID + workerFileName.charAt(i);
                ++i;
            }
            Integer n = workerID = Integer.valueOf(Integer.parseInt(wID));
            Integer n2 = workerID = Integer.valueOf(workerID + 1);
            List<String> cleanLines = TraceMerger.getWorkerEvents(workerFile);
            Map<Integer, List<LineInfo>> workerSyncEvents = this.getSyncEvents(workerFile.getPath(), workerID);
            this.writeWorkerEvents(masterSyncEvents, workerSyncEvents, cleanLines, workerID);
        }
        this.masterWriter.close();
    }

    private boolean isEmpty(String[] array) {
        for (String s : array) {
            if (s == null) continue;
            return false;
        }
        return true;
    }

    protected void mergePRVsIntoNewFile() throws Exception {
        int i;
        LOGGER.debug("Generating trace header");
        if (DEBUG) {
            LOGGER.debug("Adding data from .prv header from file: " + this.workersTraceRowPath[0]);
        }
        BufferedReader[] readersArray = new BufferedReader[this.workersTraces.length];
        String[] lines = new String[readersArray.length];
        for (int i2 = 0; i2 < this.workersTraces.length; ++i2) {
            LOGGER.debug("Adding data from .prv header from file: " + this.workersTraceRowPath[i2]);
            readersArray[i2] = new BufferedReader(new FileReader(this.workersTraces[i2]));
        }
        String masterTrace = readersArray[0].readLine();
        PrvHeader masterHeader = new PrvHeader(masterTrace);
        for (i = 1; i < this.workersTraces.length; ++i) {
            String headerString = readersArray[i].readLine();
            PrvHeader header = new PrvHeader(headerString);
            masterHeader.addAsAplication(header);
        }
        for (i = 0; i < this.workersTraces.length; ++i) {
            lines[i] = readersArray[i].readLine();
        }
        this.masterWriter.println(masterHeader.toString());
        while (!this.isEmpty(lines)) {
            int earliestLinePos = 0;
            earliestLinePos = 0;
            for (int i3 = 0; i3 < lines.length; ++i3) {
                PrvLine prvLine;
                if (lines[i3] == null || lines[i3].isEmpty() || !(prvLine = new PrvLine(lines[i3])).goesBefore(lines[earliestLinePos])) continue;
                earliestLinePos = i3;
            }
            String toWrite = lines[earliestLinePos];
            lines[earliestLinePos] = readersArray[earliestLinePos].readLine();
            this.masterWriter.println(toWrite);
        }
        for (i = 0; i < this.workersTraces.length; ++i) {
            readersArray[i].close();
        }
        this.masterWriter.close();
    }

    protected void mergeROWsIntoNewFile() throws Exception {
        LOGGER.debug("Merging .row files");
        LOGGER.debug("Adding data from .row file: " + this.workersTraceRowPath[0]);
        File firstFile = new File(this.workersTraceRowPath[0]);
        RowFile masterRow = new RowFile(firstFile);
        for (int i = 1; i < this.workersTraceRowPath.length; ++i) {
            LOGGER.debug("Adding data from .row file: " + this.workersTraceRowPath[i]);
            File file = new File(this.workersTraceRowPath[i]);
            RowFile rowFile = new RowFile(file);
            masterRow.mergeAgentRow(rowFile, i + 1);
        }
        File masterFile = new File(this.masterTraceRowPath);
        masterFile.createNewFile();
        masterRow.printInfo(masterFile);
    }

    /*
     * WARNING - void declaration
     */
    protected void mergePCFsHardwareCounters() throws IOException {
        void var5_7;
        LOGGER.debug("Merging PCF Hardware Counters into master");
        ArrayList<String> masterHWCounters = TraceMerger.getHWCounters(this.masterTracePcfPath);
        ArrayList<ArrayList<String>> allWorkersHWCounters = new ArrayList<ArrayList<String>>();
        String[] stringArray = this.workersTracePcfPath;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            String workerPcf = stringArray[var5_7];
            allWorkersHWCounters.add(TraceMerger.getHWCounters(workerPcf));
            ++var5_7;
        }
        ArrayList<String> newHWCounters = new ArrayList<String>();
        for (ArrayList arrayList : allWorkersHWCounters) {
            int differentLines = 0;
            for (String line : arrayList) {
                if (masterHWCounters.contains(line) || newHWCounters.contains(line)) continue;
                if (DEBUG) {
                    LOGGER.debug("Found new PCF counter line" + line);
                }
                newHWCounters.add(line);
                ++differentLines;
            }
            if (!DEBUG) continue;
            LOGGER.debug("Analised worker had " + differentLines + " lines to be included");
        }
        if (newHWCounters.size() > 0) {
            if (DEBUG) {
                LOGGER.debug("Adding " + newHWCounters.size() + " new counters to master PCF file.");
            }
            this.masterPcfWriter.println(COUNTER_HEADER);
            if (masterHWCounters.size() == 0) {
                if (DEBUG) {
                    LOGGER.debug("Master PCF did not contain any hardware counter.");
                }
                this.masterPcfWriter.println(HW_FIXED_COUNTER);
            }
            for (String string : newHWCounters) {
                this.masterPcfWriter.println(string);
            }
        } else if (DEBUG) {
            LOGGER.debug("No hardware counters to include in PCF.");
        }
        this.masterPcfWriter.close();
    }

    protected void createPRVswithGlobalCE() throws Exception {
        LOGGER.debug("Updating workers PRVs with global PCF index");
        ArrayList<Map<String, String>> workersCEIndex = new ArrayList<Map<String, String>>();
        for (String workerPcf : this.workersTracePcfPath) {
            workersCEIndex.add(TraceMerger.getCE(workerPcf));
        }
        Map<String, String> globalCE = this.createGlobalCoreElementsIndex(workersCEIndex);
        this.createGlobalPCF(globalCE);
        for (int i = 0; i < this.workersTracePath.length; ++i) {
            String line;
            File translatedPRV = new File(this.workersTracePath[i] + "_tmp_GlobalCE");
            boolean fileCreated = translatedPRV.createNewFile();
            if (!fileCreated) {
                throw new Exception("ERROR: couldn't create new PRV file with global CE identifiers at " + translatedPRV.getAbsolutePath());
            }
            PrintWriter writer = new PrintWriter(new FileWriter(translatedPRV, true));
            Map workerCE = (Map)workersCEIndex.get(i);
            int wokerId = i + 1;
            BufferedReader br = new BufferedReader(new FileReader(this.workersTracePath[i]));
            while ((line = br.readLine()) != null) {
                TraceMerger.writeTranslatedPRVLine(line, wokerId, globalCE, workerCE, writer);
            }
            br.close();
            writer.close();
            translatedPRV.renameTo(this.workersTraces[i]);
        }
    }

    protected Map<String, String> createGlobalCoreElementsIndex(List<Map<String, String>> workersCEIndex) throws Exception {
        LOGGER.debug("Creating global CE index");
        HashMap<String, String> globalCE = new HashMap<String, String>();
        globalCE.put("End", "0");
        int maxCEValue = 1;
        for (Map<String, String> workerCE : workersCEIndex) {
            for (Map.Entry<String, String> ce : workerCE.entrySet()) {
                String value = ce.getValue();
                if (globalCE.containsKey(value)) continue;
                globalCE.put(value, Integer.toString(maxCEValue));
                LOGGER.debug("Added " + value + " to global CE index with id: " + maxCEValue);
                ++maxCEValue;
            }
        }
        return globalCE;
    }

    private void createGlobalPCF(Map<String, String> globalCE) throws IOException {
        int currentLineNumber;
        LOGGER.debug("Creating global PCF index");
        List<String> lines = Files.readAllLines(Paths.get(this.workersTracePcfPath[0], new String[0]), StandardCharsets.UTF_8);
        for (currentLineNumber = 0; currentLineNumber < lines.size() && !CE_FIXED_COUNTER.equals(lines.get(currentLineNumber)); ++currentLineNumber) {
            this.masterPcfWriter.println(lines.get(currentLineNumber));
        }
        while (currentLineNumber < lines.size() - 1 && !lines.get(currentLineNumber).isEmpty()) {
            ++currentLineNumber;
        }
        this.masterPcfWriter.println(CE_FIXED_COUNTER);
        this.masterPcfWriter.println("VALUES");
        for (Map.Entry<String, String> ce : globalCE.entrySet()) {
            this.masterPcfWriter.println(ce.getValue() + CE_ID_VALUE_SEPARATOR + ce.getKey());
        }
        while (currentLineNumber < lines.size()) {
            this.masterPcfWriter.println(lines.get(currentLineNumber));
            ++currentLineNumber;
        }
        this.masterPcfWriter.close();
    }

    private static void writeTranslatedPRVLine(String line, int workerId, Map<String, String> globalCE, Map<String, String> workerCE, PrintWriter writer) throws Exception {
        if (!line.startsWith("#")) {
            PrvLine prvLine = new PrvLine(line);
            prvLine.translateLineToGlobalIndex(TASKS_FUNC_TYPE_STRING, globalCE, workerCE);
            prvLine.setAgentNumber(Integer.toString(workerId));
            writer.println(prvLine.toString());
        } else {
            writer.println(line);
        }
    }

    protected void removeTmpAgentFiles() throws IOException {
        for (String path : this.workersTracePath) {
            TraceMerger.removeFolder(new File(path).getParent());
        }
    }

    protected static void removeFolder(String sandBox) throws IOException {
        File wdirFile = new File(sandBox);
        TraceMerger.remove(wdirFile);
    }

    private static void remove(File f) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File child : f.listFiles()) {
                    TraceMerger.remove(child);
                }
            }
            Files.delete(f.toPath());
        }
    }

    private static void add(Map<Integer, List<LineInfo>> map, Integer key, LineInfo newValue) {
        List currentValue = map.computeIfAbsent(key, k -> new ArrayList());
        currentValue.add(newValue);
    }

    private static List<String> getWorkerEvents(File worker) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Getting worker events from: " + worker.getAbsolutePath());
        }
        List<String> lines = Files.readAllLines(Paths.get(worker.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8);
        int startIndex = 1;
        int endIndex = lines.size();
        return lines.subList(startIndex, endIndex);
    }

    private Map<Integer, List<LineInfo>> getSyncEvents(String tracePath, Integer workerID) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Getting sync events from: " + tracePath + " for worker " + workerID);
        }
        HashMap<Integer, List<LineInfo>> idToSyncInfo = new HashMap<Integer, List<LineInfo>>();
        try (FileInputStream inputStream = new FileInputStream(tracePath);
             Scanner sc = new Scanner((InputStream)inputStream, "UTF-8");){
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                Matcher m = SYNC_PATTERN.matcher(line);
                if (!m.find()) continue;
                Integer wID = workerID == -1 ? Integer.parseInt(m.group(WORKER_ID_INDEX)) : workerID;
                String resourceID = m.group(R_ID_INDEX);
                Long timestamp = Long.parseLong(m.group(TIMESTAMP_INDEX));
                Long value = Long.parseLong(m.group(VALUE_INDEX));
                TraceMerger.add(idToSyncInfo, wID, new LineInfo(resourceID, timestamp, value));
            }
            if (sc.ioException() != null) {
                throw sc.ioException();
            }
        }
        return idToSyncInfo;
    }

    private void writeWorkerEvents(Map<Integer, List<LineInfo>> masterSyncEvents, Map<Integer, List<LineInfo>> workerSyncEvents, List<String> eventsLine, Integer workerID) throws Exception {
        LineInfo workerHeader = this.getWorkerInfo(masterSyncEvents.get(workerID), workerSyncEvents.get(workerID));
        LOGGER.debug("Writing " + eventsLine.size() + " lines from worker " + workerID + " with " + workerHeader.getValue() + " threads");
        for (String line : eventsLine) {
            String newEvent = TraceMerger.updateEvent(workerHeader, line, workerID);
            if (newEvent.isEmpty()) continue;
            this.masterWriter.println(newEvent);
        }
    }

    private static String updateEvent(LineInfo workerHeader, String line, Integer workerID) {
        int numThreads = (int)workerHeader.getValue();
        Matcher taskMatcher = WORKER_THREAD_INFO_PATTERN.matcher(line);
        String newLine = "";
        if (taskMatcher.find()) {
            Integer threadID = Integer.parseInt(taskMatcher.group(WORKER_THREAD_ID));
            Integer stateID = Integer.parseInt(taskMatcher.group(STATE_TYPE));
            int newThreadID = threadID;
            if (threadID > 1) {
                newThreadID = numThreads + 4 - threadID;
            }
            String eventHeader = stateID + ":" + newThreadID + ":1:" + workerID + ":" + newThreadID;
            Long timestamp = workerHeader.getTimestamp() + Long.parseLong(taskMatcher.group(WORKER_TIMESTAMP));
            String lineInfo = taskMatcher.group(WORKER_LINE_INFO);
            newLine = eventHeader + ":" + timestamp + ":" + lineInfo;
        }
        return newLine;
    }

    private LineInfo getWorkerInfo(List<LineInfo> masterSyncEvents, List<LineInfo> workerSyncEvents) throws Exception {
        if (masterSyncEvents.size() < 3) {
            throw new Exception("ERROR: Malformed master trace. Master sync events not found");
        }
        if (workerSyncEvents.size() < 3) {
            throw new Exception("ERROR: Malformed worker trace. Worker sync events not found");
        }
        LineInfo javaStart = masterSyncEvents.get(0);
        LineInfo javaSync = masterSyncEvents.get(2);
        LineInfo workerSync = workerSyncEvents.get(2);
        Long syncDifference = Math.abs(javaSync.getValue() / 1000L - workerSync.getValue());
        Long realStart = Math.abs(javaSync.getTimestamp() - workerSync.getTimestamp()) - syncDifference;
        return new LineInfo(javaStart.getResourceId(), realStart, javaStart.getValue());
    }

    private static ArrayList<String> getHWCounters(String tracePcfPath) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Getting pcf hw counters from: " + tracePcfPath);
        }
        ArrayList<String> hwCounters = new ArrayList<String>();
        List<String> lines = Files.readAllLines(Paths.get(tracePcfPath, new String[0]), StandardCharsets.UTF_8);
        for (String line : lines) {
            if (!line.startsWith(HW_COUNTER_LINE_HEADER)) continue;
            hwCounters.add(line);
        }
        return hwCounters;
    }

    private static Map<String, String> getCE(String tracePcfPath) throws Exception {
        if (DEBUG) {
            LOGGER.debug("Getting PCF CE from: " + tracePcfPath);
        }
        Pattern numberPattern = Pattern.compile("[0-9]+");
        HashMap<String, String> coreElements = new HashMap<String, String>();
        List<String> lines = Files.readAllLines(Paths.get(tracePcfPath, new String[0]), StandardCharsets.UTF_8);
        int headerLine = lines.indexOf(CE_FIXED_COUNTER);
        if (headerLine != -1) {
            for (int ceLine = headerLine + 2; ceLine < lines.size() - 1 && !lines.get(ceLine).isEmpty(); ++ceLine) {
                String[] values = lines.get(ceLine).split(CE_ID_VALUE_SEPARATOR);
                if (values.length != 2 || values[1].isEmpty() || !numberPattern.matcher(values[0]).matches()) {
                    throw new Exception("ERROR: Malformed CE in PFC " + tracePcfPath + "  line " + ceLine);
                }
                coreElements.put(values[0], values[1]);
            }
        }
        return coreElements;
    }

    private static Map<String, String> getReversedCE(String tracePcfPath) throws Exception {
        if (DEBUG) {
            LOGGER.debug("Getting PCF CE from: " + tracePcfPath);
        }
        Pattern numberPattern = Pattern.compile("[0-9]+");
        HashMap<String, String> coreElements = new HashMap<String, String>();
        List<String> lines = Files.readAllLines(Paths.get(tracePcfPath, new String[0]), StandardCharsets.UTF_8);
        int headerLine = lines.indexOf(CE_FIXED_COUNTER);
        if (headerLine != -1) {
            for (int ceLine = headerLine + 2; ceLine < lines.size() - 1 && !lines.get(ceLine).isEmpty(); ++ceLine) {
                String[] values = lines.get(ceLine).split(CE_ID_VALUE_SEPARATOR);
                if (values.length != 2 || values[1].isEmpty() || !numberPattern.matcher(values[0]).matches()) {
                    throw new Exception("ERROR: Malformed CE in PFC " + tracePcfPath + "  line " + ceLine);
                }
                coreElements.put(values[1], values[0]);
            }
        }
        return coreElements;
    }

    protected static void copyFile(File sourceFile, File destinationFile) throws IOException {
        try (FileInputStream in = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(destinationFile);){
            int length;
            byte[] buf = new byte[1024];
            while ((length = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, length);
            }
        }
    }

    private class LineInfo {
        private final String resourceId;
        private final Long value;
        private final Long timestamp;

        public LineInfo(String resourceID, Long timestamp, long value) {
            this.resourceId = resourceID;
            this.timestamp = timestamp;
            this.value = value;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public long getValue() {
            return this.value;
        }
    }
}

