/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm;

import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.MessageHandler;
import es.bsc.comm.Node;
import es.bsc.comm.exceptions.CommException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransferManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.comm.TransferManager");
    private static final String ERROR_PROPERTIES = "Error loading properties file";
    private EventManager em;

    public void init(String eventManagerClassName, String properties, MessageHandler mh) throws CommException {
        LOGGER.debug("TransferManager init");
        try {
            Constructor<?> constrEventManager = Class.forName(eventManagerClassName).getConstructor(MessageHandler.class);
            this.em = (EventManager)constrEventManager.newInstance(mh);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Can not find adaptor class " + eventManagerClassName + ".", (Throwable)e);
            throw new CommException(CommException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Class " + eventManagerClassName + " has no valid constructor.", (Throwable)e);
            throw new CommException(CommException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (InstantiationException e) {
            LOGGER.error("Can not instantiate adaptor " + eventManagerClassName + ".", (Throwable)e);
            throw new CommException(CommException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal access on adaptor " + eventManagerClassName + " creation", (Throwable)e);
            throw new CommException(CommException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Illegal argument on adaptor " + eventManagerClassName + " creation", (Throwable)e);
            throw new CommException(CommException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Wrong target for " + eventManagerClassName + " invocation", (Throwable)e);
            throw new CommException(CommException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (Exception e) {
            LOGGER.error(e);
            throw new CommException(CommException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        try {
            this.em.init(properties);
        }
        catch (Exception e) {
            LOGGER.error(ERROR_PROPERTIES, (Throwable)e);
            throw new CommException(CommException.ErrorType.EVENT_MANAGER_INIT, e);
        }
        try {
            mh.init();
        }
        catch (Exception e) {
            LOGGER.error(ERROR_PROPERTIES, (Throwable)e);
            throw new CommException(CommException.ErrorType.MESSAGE_HANDLER_INIT, e);
        }
    }

    public void startServer(Node n) throws CommException {
        LOGGER.debug("TransferManager Start Server");
        this.em.startServer(n);
        this.em.start();
    }

    public void join() throws InterruptedException {
        this.em.join();
    }

    public Connection startConnection(Node node) {
        return this.em.startConnection(node);
    }

    public void shutdown(boolean gently, Connection notifyTo) {
        LOGGER.debug("TransferManager shutdown");
        this.em.shutdown(gently, notifyTo);
    }
}

