/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.tracing;

import es.bsc.compss.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceScript {
    public static final String RELATIVE_PATH = "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "trace" + File.separator + "trace.sh";
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();

    public static final int start(String iDir, String traceDir, String eventType, String taskId, String slot) throws IOException, InterruptedException {
        return TraceScript.invokeScript(iDir, "start", traceDir, eventType, taskId, slot);
    }

    public static final int end(String iDir, String traceDir, String eventType, String slot) throws IOException, InterruptedException {
        return TraceScript.invokeScript(iDir, "end", traceDir, slot);
    }

    public static final int init(String iDir, String traceDir, String node, String nSlot) throws IOException, InterruptedException {
        return TraceScript.invokeScript(iDir, "init", traceDir, node, nSlot);
    }

    public static final int package_extrae(String iDir, String traceDir, String packagePath, String hostId) throws IOException, InterruptedException {
        return TraceScript.invokeScript(iDir, "package", traceDir, packagePath, hostId);
    }

    public static final int gentrace_extrae(String iDir, String traceDir, String appName, String numResources) throws IOException, InterruptedException {
        return TraceScript.invokeScript(iDir, "gentrace", traceDir, appName, numResources);
    }

    private static int invokeScript(String iDir, String cmd, String workingDirPath, String ... args) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(iDir + File.separator + RELATIVE_PATH);
        List<String> command = pb.command();
        command.add(cmd);
        command.add(workingDirPath);
        for (String arg : args) {
            command.add(arg);
        }
        pb.environment().remove("LD_PRELOAD");
        Process p = pb.start();
        if (DEBUG) {
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out, LOGGER, false);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err, LOGGER, true);
            outputGobbler.start();
            errorGobbler.start();
        }
        return p.waitFor();
    }
}

