/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrvHeader {
    private static final String SPLIT_HEADER_REGEX = ":\\s*(?![^()]*\\))";
    public static final Pattern INSIDE_PARENTHESIS_PATTERN = Pattern.compile("\\(.+\\)");
    private String singAndDate;
    private String duration;
    private List<String> cpusPerNode;
    private List<String> applicationList;
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");

    public PrvHeader(String header) throws Exception {
        String[] headerParts;
        if (header.endsWith(",0")) {
            header = header.substring(0, header.length() - 2);
        }
        if ((headerParts = header.split(SPLIT_HEADER_REGEX)).length < 4) {
            throw new Exception("prv header doesn't have the expected format(wrong number of parts): " + header);
        }
        this.singAndDate = headerParts[0];
        this.duration = headerParts[1];
        this.cpusPerNode = Arrays.asList(this.getInsideParenthresis(headerParts[2]).split(","));
        this.applicationList = new ArrayList<String>();
        for (int i = 4; i < headerParts.length; ++i) {
            this.applicationList.add(headerParts[i]);
        }
    }

    public void transformNodesToAplications() throws Exception {
        if (this.applicationList.size() != 1) {
            throw new Exception("prv header doesn't have the expected format (expected only one application): " + this.toString());
        }
        String[] appListValues = this.getInsideParenthresis(this.applicationList.get(0)).split(",");
        ArrayList<String> newAppList = new ArrayList<String>();
        ArrayList<String> newcpuNodesList = new ArrayList<String>();
        for (String appValue : appListValues) {
            newcpuNodesList.add(appValue.substring(0, appValue.indexOf(":")));
            newAppList.add("1(" + appValue + ")");
        }
        this.applicationList = newAppList;
        this.cpusPerNode = newcpuNodesList;
    }

    private String getInsideParenthresis(String block) {
        Matcher numThreadMatcher = INSIDE_PARENTHESIS_PATTERN.matcher(block);
        numThreadMatcher.find();
        String inside = numThreadMatcher.group(0);
        inside = inside.substring(1, inside.length() - 1);
        return inside;
    }

    public void addAsAplication(PrvHeader headerToMerge) {
        this.cpusPerNode = new ArrayList<String>(this.cpusPerNode);
        this.cpusPerNode.addAll(headerToMerge.cpusPerNode);
        this.applicationList = new ArrayList<String>(this.applicationList);
        this.applicationList.addAll(headerToMerge.applicationList);
    }

    private String splitRuntimeExecutorsApplication(int numberOfRuntimeThreads, String oldApp) {
        int oldNumThreads = Integer.parseInt(this.getInsideParenthresis(oldApp).split(":")[0]);
        String runtimeThreads = Integer.toString(numberOfRuntimeThreads);
        int nonRuntimeThreads = oldNumThreads - numberOfRuntimeThreads;
        if (nonRuntimeThreads > 0) {
            return "2(" + runtimeThreads + ":1," + Integer.toString(nonRuntimeThreads) + ":2)";
        }
        return "1(" + runtimeThreads + ":1)";
    }

    public void splitRuntimeExecutors(int[] numRuntimeThreadsPerApp) throws Exception {
        for (int i = 0; i < this.applicationList.size(); ++i) {
            String newApp = this.splitRuntimeExecutorsApplication(numRuntimeThreadsPerApp[i], this.applicationList.get(i));
            this.applicationList.set(i, newApp);
        }
    }

    public String toString() {
        String nodesString = this.cpusPerNode.size() + "(" + String.join((CharSequence)",", this.cpusPerNode) + ")";
        String applicationsString = this.applicationList.size() + ":" + String.join((CharSequence)":", this.applicationList);
        return this.singAndDate + ":" + this.duration + ":" + nodesString + ":" + applicationsString;
    }
}

