/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.types;

import es.bsc.compss.util.tracing.ThreadIdentifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrvLine {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    public static final int EVENT_TYPE = 0;
    public static final int TIMESTAMP_POS = 5;
    public static final int STATE_MACHINE_POS = 2;
    public static final int STATE_RUNTIME_EXECUTOR_POS = 3;
    public static final int STATE_THREAD_NUMBER_POS = 4;
    public static final int STATE_EVENTS_START_POS = 6;
    public static final int COM_SEND_MACHINE_POS = 2;
    public static final int COM_SEND_RUNTIME_EXECUTOR_POS = 3;
    public static final int COM_SEND_THREAD_NUMBER_POS = 4;
    public static final int COM_RECIV_MACHINE_POS = 8;
    public static final int COM_RECIV_RUNTIME_EXECUTOR_POS = 9;
    public static final int COM_RECIV_THREAD_NUMBER_POS = 10;
    private String[] values;

    public PrvLine(String line) {
        this.values = line.split(":");
    }

    public void setAgentNumber(String s) {
        this.values[2] = s;
    }

    public ThreadIdentifier getStateLineThreadIdentifier() {
        String machine = this.values[2];
        String task = this.values[3];
        String thread = this.values[4];
        return new ThreadIdentifier(machine, task, thread);
    }

    private void setStateLineThreadIdentifier(ThreadIdentifier id) {
        this.values[2] = id.getApp();
        this.values[3] = id.getTask();
        this.values[4] = id.getThread();
    }

    private ThreadIdentifier getComSenderThreadIdentifier() {
        String machine = this.values[2];
        String task = this.values[3];
        String thread = this.values[4];
        return new ThreadIdentifier(machine, task, thread);
    }

    private void setComSenderThreadIdentifier(ThreadIdentifier id) {
        this.values[2] = id.getApp();
        this.values[3] = id.getTask();
        this.values[4] = id.getThread();
    }

    private ThreadIdentifier getComRecivThreadIdentifier() {
        String machine = this.values[8];
        String task = this.values[9];
        String thread = this.values[10];
        return new ThreadIdentifier(machine, task, thread);
    }

    private void setComRecivThreadIdentifier(ThreadIdentifier id) throws Exception {
        this.values[8] = id.getApp();
        this.values[9] = id.getTask();
        this.values[10] = id.getThread();
    }

    public Map<String, String> getEvents() {
        HashMap<String, String> result = new HashMap<String, String>();
        if ("3".equals(this.values[0])) {
            return result;
        }
        for (int i = 6; i < this.values.length; i += 2) {
            result.put(this.values[i], this.values[i + 1]);
        }
        return result;
    }

    public void translateLineToGlobalIndex(String eventGroupIdentifier, Map<String, String> globalIndex, Map<String, String> localIndex) {
        for (int i = 6; i < this.values.length; i += 2) {
            String globalValue;
            if (!eventGroupIdentifier.equals(this.values[i])) continue;
            String eventValue = this.values[i + 1];
            String eventIdentifier = localIndex.get(eventValue);
            this.values[i + 1] = globalValue = globalIndex.get(eventIdentifier);
        }
    }

    public String toString() {
        return String.join((CharSequence)":", this.values);
    }

    public void translateLineThreads(Map<ThreadIdentifier, ThreadIdentifier> translations) throws Exception {
        if (!"3".equals(this.values[0])) {
            ThreadIdentifier oldThreadId = this.getStateLineThreadIdentifier();
            if (translations.containsKey(oldThreadId)) {
                this.setStateLineThreadIdentifier(translations.get(oldThreadId));
            }
        } else {
            ThreadIdentifier recivThreadId;
            ThreadIdentifier senderThreadId = this.getComSenderThreadIdentifier();
            if (translations.containsKey(senderThreadId)) {
                this.setComSenderThreadIdentifier(translations.get(senderThreadId));
            }
            if (translations.containsKey(recivThreadId = this.getComRecivThreadIdentifier())) {
                this.setComRecivThreadIdentifier(translations.get(recivThreadId));
            }
        }
    }

    public boolean goesBefore(String otherLine) throws Exception {
        if (otherLine == null) {
            return false;
        }
        return this.goesBefore(new PrvLine(otherLine));
    }

    public boolean goesBefore(PrvLine otherLine) {
        int typeB;
        long timeB;
        long timeA = new Long(this.values[5]);
        if (timeA < (timeB = new Long(otherLine.values[5]).longValue())) {
            return true;
        }
        if (timeA > timeB) {
            return false;
        }
        int typeA = new Integer(this.values[0]);
        return typeA <= (typeB = new Integer(otherLine.values[0]).intValue());
    }
}

