/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOResult;
import es.bsc.compss.nio.NIOResultCollection;
import es.bsc.compss.types.annotations.parameter.DataType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOTaskResult
implements Externalizable {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.API");
    private int jobId;
    private List<NIOResult> results = new LinkedList<NIOResult>();

    public NIOTaskResult() {
    }

    public NIOTaskResult(int jobId, Object[][] params) {
        this.jobId = jobId;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                this.results.add(new NIOResult(null, null));
                continue;
            }
            if (params[i][0] == DataType.COLLECTION_T) {
                this.results.add(new NIOResultCollection(params[i]));
                continue;
            }
            this.results.add(new NIOResult((DataType)((Object)params[i][0]), params[i][1].toString()));
        }
    }

    public NIOTaskResult(int jobId, List<NIOParam> arguments, NIOParam targetParam, List<NIOParam> results) {
        this.jobId = jobId;
        for (NIOParam np : arguments) {
            this.results.add(np.getResult());
        }
        if (targetParam != null) {
            this.results.add(targetParam.getResult());
        }
        for (NIOParam np : results) {
            this.results.add(np.getResult());
        }
    }

    public int getJobId() {
        return this.jobId;
    }

    public List<NIOResult> getParamResults() {
        return this.results;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = in.readInt();
        this.results = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.jobId);
        out.writeObject(this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[JOB_RESULT ");
        sb.append("[JOB ID= ").append(this.jobId).append("]");
        sb.append("[PARAM_RESULTS");
        for (NIOResult param : this.results) {
            sb.append(" ").append(param);
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

