/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.nio.master.utils.NIOParamFactory;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.MultiNodeImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import java.util.List;

public class NIOJob
extends Job<NIOWorkerNode> {
    protected final List<String> slaveWorkersNodeNames;

    public NIOJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        super(taskId, taskParams, impl, res, listener);
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
    }

    @Override
    public TaskType getType() {
        return TaskType.METHOD;
    }

    @Override
    public String getHostName() {
        return this.worker.getName();
    }

    @Override
    public void submit() throws Exception {
        LOGGER.info("Submit NIOJob with ID " + this.jobId);
        NIOAdaptor.submitTask(this);
    }

    public NIOTask prepareJob() {
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        switch (absMethodImpl.getMethodType()) {
            case METHOD: {
                MethodImplementation methodImpl = (MethodImplementation)absMethodImpl;
                String methodName = methodImpl.getAlternativeMethodName();
                if (methodName != null && !methodName.isEmpty()) break;
                methodImpl.setAlternativeMethodName(this.taskParams.getName());
                break;
            }
            case MULTI_NODE: {
                MultiNodeImplementation multiNodeImpl = (MultiNodeImplementation)absMethodImpl;
                String multiNodeMethodName = multiNodeImpl.getMethodName();
                if (multiNodeMethodName != null && !multiNodeMethodName.isEmpty()) break;
                multiNodeImpl.setMethodName(this.taskParams.getName());
                break;
            }
        }
        LinkedList<NIOParam> params = this.addParams();
        int numParams = params.size() - this.taskParams.getNumReturns();
        NIOTask nt = new NIOTask(this.getLang(), DEBUG, absMethodImpl, this.taskParams.hasTargetObject(), this.taskParams.getNumReturns(), params, numParams, absMethodImpl.getRequirements(), this.slaveWorkersNodeNames, this.taskId, this.impl.getTaskType(), this.jobId, this.history, this.transferId, this.getTimeOut());
        return nt;
    }

    private LinkedList<NIOParam> addParams() {
        LinkedList<NIOParam> params = new LinkedList<NIOParam>();
        for (Parameter param : this.taskParams.getParameters()) {
            params.add(NIOParamFactory.fromParameter(param));
        }
        return params;
    }

    public void taskFinished(boolean successful, Exception e) {
        if (successful) {
            this.listener.jobCompleted(this);
        } else if (e instanceof COMPSsException) {
            this.listener.jobFailed(this, JobEndStatus.EXCEPTION, (COMPSsException)e);
        } else {
            this.listener.jobFailed(this, JobEndStatus.EXECUTION_FAILED, null);
        }
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public String toString() {
        AbstractMethodImplementation method = (AbstractMethodImplementation)this.impl;
        String definition = method.getMethodDefinition();
        String methodName = this.taskParams.getName();
        return "NIOJob JobId" + this.jobId + " for method " + methodName + " with definition " + definition;
    }
}

