/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.utils;

import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.exceptions.NIOException;
import es.bsc.compss.nio.utils.NIOBindingDataManager;
import es.bsc.compss.nio.utils.NIOBindingObjectStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOBindingObjectReceiver
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private final NIOBindingObjectStream nbos;
    private final String id;
    private final int type;
    private final NIOConnection c;

    public NIOBindingObjectReceiver(NIOConnection c, String id, int type, NIOBindingObjectStream nbos) {
        this.nbos = nbos;
        this.id = id;
        this.type = type;
        this.c = c;
    }

    @Override
    public void run() {
        int res = NIOBindingDataManager.receiveNativeObject(this.id, this.type, this.nbos);
        if (res != 0) {
            LOGGER.error("Error (" + res + ") receiving native object " + this.id);
            this.c.error(new NIOException(NIOException.SpecificErrorType.READ, "Error (" + res + ") receiving native object."));
        } else {
            NIOBindingDataManager.objectReceived(this.c);
        }
        this.c.finishConnection();
    }
}

