/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PythonMPIImplementation
extends AbstractMethodImplementation
implements Externalizable {
    public static final int NUM_PARAMS = 3;
    private String declaringClass;
    private String alternativeMethod;
    private String mpiRunner;
    private String workingDir;

    public PythonMPIImplementation() {
    }

    public PythonMPIImplementation(String methodClass, String altMethodName, String workingDir, String mpiRunner, Integer coreId, Integer implementationId, String signature, MethodResourceDescription requirements) {
        super(coreId, implementationId, signature, requirements);
        this.declaringClass = methodClass;
        this.alternativeMethod = altMethodName;
        this.mpiRunner = mpiRunner;
        this.workingDir = workingDir;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getAlternativeMethodName() {
        return this.alternativeMethod;
    }

    public void setAlternativeMethodName(String alternativeMethod) {
        this.alternativeMethod = alternativeMethod;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getMpiRunner() {
        return this.mpiRunner;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.PYTHON_MPI;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DECLARING CLASS=").append(this.declaringClass);
        sb.append(", METHOD NAME=").append(this.alternativeMethod);
        sb.append(", MPI RUNNER=").append(this.mpiRunner);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " Python MPI Method declared in class " + this.declaringClass + "." + this.alternativeMethod + " with MPIrunner " + this.mpiRunner + ": " + this.requirements.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.declaringClass = (String)in.readObject();
        this.alternativeMethod = (String)in.readObject();
        this.mpiRunner = (String)in.readObject();
        this.workingDir = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.declaringClass);
        out.writeObject(this.alternativeMethod);
        out.writeObject(this.mpiRunner);
        out.writeObject(this.workingDir);
    }
}

