/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.distrostreamlib.requests;

import es.bsc.distrostreamlib.types.RequestType;
import java.util.concurrent.Semaphore;

public abstract class Request {
    protected final RequestType rt;
    private boolean hasBeenProcessed;
    private final Semaphore waitSem;
    private int errorCode;
    private String errorMessage;
    private String responseMessage;

    public Request(RequestType rt) {
        this.rt = rt;
        this.hasBeenProcessed = false;
        this.waitSem = new Semaphore(0);
        this.errorCode = -1;
        this.errorMessage = null;
        this.responseMessage = null;
    }

    public final RequestType getType() {
        return this.rt;
    }

    public final boolean isProcessed() {
        return this.hasBeenProcessed;
    }

    public final void waitProcessed() {
        try {
            this.waitSem.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final String getResponseMessage() {
        return this.responseMessage;
    }

    public final void setError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public final void setResponse(String message) {
        this.errorCode = 0;
        this.responseMessage = message;
    }

    public final void setProcessed() {
        this.hasBeenProcessed = true;
        this.waitSem.release();
    }

    public abstract String getRequestMessage();

    public String toString() {
        return this.rt.name();
    }
}

