/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm.messages.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

public class CommTask
extends NIOTask {
    private CommResource orchestrator;
    private String cei;

    public CommTask() {
    }

    public CommTask(COMPSsConstants.Lang lang, boolean workerDebug, AbstractMethodImplementation impl, String cei, boolean hasTarget, int numReturns, LinkedList<NIOParam> params, int numParams, MethodResourceDescription reqs, List<String> slaveWorkersNodeNames, int taskId, TaskType taskType, int jobId, JobHistory hist, int transferGroupId, long timeOut, CommResource orchestrator) {
        super(lang, workerDebug, impl, hasTarget, numReturns, params, numParams, reqs, slaveWorkersNodeNames, taskId, taskType, jobId, hist, transferGroupId, timeOut);
        this.cei = cei;
        this.orchestrator = orchestrator;
    }

    public CommTask(COMPSsConstants.Lang lang, boolean workerDebug, AbstractMethodImplementation impl, String cei, LinkedList<NIOParam> arguments, NIOParam target, LinkedList<NIOParam> results, List<String> slaveWorkersNodeNames, int taskId, int jobId, JobHistory hist, int transferGroupId, long timeOut, CommResource orchestrator) {
        super(lang, workerDebug, impl, arguments, target, results, slaveWorkersNodeNames, taskId, jobId, hist, transferGroupId, timeOut);
        this.cei = cei;
        this.orchestrator = orchestrator;
    }

    public String getCei() {
        return this.cei;
    }

    public CommResource getOrchestrator() {
        return this.orchestrator;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.orchestrator = (CommResource)in.readObject();
        boolean ceiDefined = in.readBoolean();
        if (ceiDefined) {
            this.cei = in.readUTF();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.orchestrator);
        boolean ceiDefined = this.cei != null && !this.cei.isEmpty();
        out.writeBoolean(ceiDefined);
        if (ceiDefined) {
            out.writeUTF(this.cei);
        }
    }
}

