/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.logging.log4j.Logger;

public class Classpath {
    public static void loadPath(String jarPath, Logger logger) throws FileNotFoundException {
        File directory = new File(jarPath);
        if (!directory.exists()) {
            throw new FileNotFoundException();
        }
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = null;
        try {
            method = sysclass.getDeclaredMethod("addURL", URL.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (method == null) {
            throw new FileNotFoundException();
        }
        method.setAccessible(true);
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Classpath.scanFolder(sysloader, method, directory, logger);
    }

    private static void scanFolder(Object callee, Method method, File file, Logger logger) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                Classpath.scanFolder(callee, method, child, logger);
            }
        } else {
            try {
                method.invoke(callee, new File(file.getAbsolutePath()).toURI().toURL());
                logger.info(file.getAbsolutePath() + " ADDED TO THE CLASSPATH");
            }
            catch (Exception e) {
                logger.error("COULD NOT LOAD JAR " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }
}

