/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.stage;

import es.bsc.comm.stage.Stage;
import java.nio.ByteBuffer;

public abstract class Transfer
extends Stage {
    protected static final int SIZE_SIZE = 8;
    protected static final int TYPE_SIZE = 4;
    protected static final int DEST_SIZE = 4;
    protected static final int INIT_SIZE = 8;
    protected static final int HEADER_SIZE = 16;
    protected Type type;
    protected Destination destination;
    protected String fileName;
    protected byte[] array;
    protected Object object;
    protected ByteBuffer buffer;
    protected boolean sizeInit = false;
    protected long totalSize = -1L;
    protected long remainingSize;

    public Transfer(boolean notifyErrors) {
        super(notifyErrors);
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    protected void setSize(long size) {
        this.totalSize = size;
        this.remainingSize = size;
        this.sizeInit = true;
    }

    public long getSize() {
        return this.totalSize;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isData() {
        return this.type == Type.DATA;
    }

    public boolean isCommand() {
        return this.type == Type.COMMAND;
    }

    public abstract Direction getDirection();

    public Destination getDestination() {
        return this.destination;
    }

    public boolean isFile() {
        return this.destination == Destination.FILE;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isObject() {
        return this.destination == Destination.OBJECT;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean isArray() {
        return this.destination == Destination.ARRAY;
    }

    public byte[] getArray() {
        return this.array;
    }

    public boolean isByteBuffer() {
        return this.destination == Destination.BYTEBUFFER;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + (Object)((Object)this.getDirection()) + " " + (Object)((Object)this.type) + " " + (Object)((Object)this.destination) + "]";
    }

    public static enum Destination {
        OBJECT,
        FILE,
        ARRAY,
        BYTEBUFFER;

    }

    public static enum Type {
        COMMAND,
        DATA;

    }

    public static enum Direction {
        SEND,
        RECEIVE;

    }
}

