/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.comm.Connection;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.stage.Transfer;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.data.BindingDataManager;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOMessageHandler;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.nio.commands.CommandCancelTask;
import es.bsc.compss.nio.commands.CommandDataReceived;
import es.bsc.compss.nio.commands.CommandExecutorShutdown;
import es.bsc.compss.nio.commands.CommandExecutorShutdownACK;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;
import es.bsc.compss.nio.commands.CommandNewTask;
import es.bsc.compss.nio.commands.CommandRemoveObsoletes;
import es.bsc.compss.nio.commands.CommandShutdown;
import es.bsc.compss.nio.commands.CommandShutdownACK;
import es.bsc.compss.nio.commands.tracing.CommandGenerateDone;
import es.bsc.compss.nio.commands.tracing.CommandGeneratePackage;
import es.bsc.compss.nio.commands.workerfiles.CommandGenerateWorkerDebugFiles;
import es.bsc.compss.nio.commands.workerfiles.CommandWorkerDebugFilesDone;
import es.bsc.compss.nio.exceptions.SerializedObjectException;
import es.bsc.compss.nio.master.NIOJob;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.nio.master.WorkerStarter;
import es.bsc.compss.nio.master.configuration.NIOConfiguration;
import es.bsc.compss.nio.requests.DataRequest;
import es.bsc.compss.nio.requests.MasterDataRequest;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.OperationEndState;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.project.jaxb.ExternalAdaptorProperties;
import es.bsc.compss.types.project.jaxb.NIOAdaptorProperties;
import es.bsc.compss.types.project.jaxb.PropertyAdaptorType;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.resources.jaxb.ResourcesExternalAdaptorProperties;
import es.bsc.compss.types.resources.jaxb.ResourcesNIOAdaptorProperties;
import es.bsc.compss.types.resources.jaxb.ResourcesPropertyAdaptorType;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOAdaptor
extends NIOAgent
implements CommAdaptor {
    private static final Logger LOGGER;
    private static final boolean WORKER_DEBUG;
    public static final int MAX_SEND = 1000;
    public static final int MAX_RECEIVE = 1000;
    public static final int MAX_SEND_WORKER = 5;
    public static final int MAX_RECEIVE_WORKER = 5;
    private static final int BASE_MASTER_PORT = 43000;
    private static final int MAX_RANDOM_VALUE = 1000;
    public static final int MASTER_PORT;
    private static final String JOBS_DIR;
    private static final String TERM_ERR = "Error terminating";
    private static final Set<NIOWorkerNode> NODES;
    private static final ConcurrentMap<Integer, NIOJob> RUNNING_JOBS;
    private static final Map<Integer, LinkedList<Copy>> GROUP_TO_COPY;
    private static final Map<Connection, ClosingWorker> STOPPING_NODES;
    private static final Map<Connection, ClosingExecutor> STOPPING_EXECUTORS;
    private static final Map<Connection, Semaphore> PENDING_MODIFICATIONS;
    private final boolean persistentC;
    private final Semaphore tracingGeneration;
    private final Semaphore workersDebugInfo;

    public NIOAdaptor() {
        super(1000, 1000, MASTER_PORT);
        String persistentCStr = System.getProperty("compss.worker.persistent.c");
        if (persistentCStr == null || persistentCStr.isEmpty() || persistentCStr.equals("null")) {
            persistentCStr = "false";
        }
        this.persistentC = Boolean.parseBoolean(persistentCStr);
        this.tracingGeneration = new Semaphore(0);
        this.workersDebugInfo = new Semaphore(0);
        File file = new File(JOBS_DIR);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    @Override
    public void init() {
        String errMsg;
        LOGGER.info("Initializing NIO Adaptor...");
        this.masterNode = new NIONode(null, MASTER_PORT);
        NIOMessageHandler mhm = new NIOMessageHandler(this);
        LOGGER.debug("  Initializing the TransferManager structures...");
        try {
            TM.init(NIO_EVENT_MANAGER_CLASS, null, mhm);
        }
        catch (CommException ce) {
            errMsg = "Error initializing the TransferManager";
            ErrorManager.error(errMsg, ce);
        }
        this.tracing = System.getProperty("compss.tracing") != null && Integer.parseInt(System.getProperty("compss.tracing")) > 0;
        this.tracingLevel = Integer.parseInt(System.getProperty("compss.tracing"));
        LOGGER.debug("  Starting transfer server...");
        try {
            TM.startServer(this.masterNode);
        }
        catch (CommException ce) {
            errMsg = "Error starting transfer server";
            ErrorManager.error(errMsg, ce);
        }
    }

    @Override
    public Configuration constructConfiguration(Map<String, Object> projectProperties, Map<String, Object> resourcesProperties) throws ConstructConfigurationException {
        NIOConfiguration config = new NIOConfiguration(this.getClass().getName());
        NIOAdaptorProperties propsProject = null;
        ResourcesNIOAdaptorProperties propsResources = null;
        if (resourcesProperties != null) {
            propsResources = (ResourcesNIOAdaptorProperties)resourcesProperties.get("Ports");
            ResourcesExternalAdaptorProperties reap = (ResourcesExternalAdaptorProperties)resourcesProperties.get("Properties");
            if (reap != null) {
                for (ResourcesPropertyAdaptorType resourcesPropertyAdaptorType : reap.getProperty()) {
                    config.addProperty(resourcesPropertyAdaptorType.getName(), resourcesPropertyAdaptorType.getValue());
                }
            }
        }
        if (projectProperties != null) {
            propsProject = (NIOAdaptorProperties)projectProperties.get("Ports");
            ExternalAdaptorProperties eap = (ExternalAdaptorProperties)projectProperties.get("Properties");
            if (eap != null) {
                for (PropertyAdaptorType propertyAdaptorType : eap.getProperty()) {
                    config.addProperty(propertyAdaptorType.getName(), propertyAdaptorType.getValue());
                }
            }
        }
        int minProject = propsProject != null ? propsProject.getMinPort() : -1;
        int minResources = -1;
        if (propsResources == null) {
            throw new ConstructConfigurationException("Resources file doesn't contain a minimum port value");
        }
        minResources = propsResources.getMinPort();
        int n = propsProject != null ? propsProject.getMaxPort() : -1;
        int maxResources = propsResources != null ? propsResources.getMaxPort() : -1;
        int minFinal = -1;
        if (minProject < 0) {
            minFinal = minResources;
        } else if (minProject < minResources) {
            LOGGER.warn("resources.xml MinPort is more restrictive than project.xml. Loading resources.xml values");
            minFinal = minResources;
        } else {
            minFinal = minProject;
        }
        int maxFinal = -1;
        if (n < 0) {
            if (maxResources < 0) {
                LOGGER.warn("MaxPort not defined in resources.xml/project.xml. Loading no limit");
            } else {
                LOGGER.warn("resources.xml MaxPort is more restrictive than project.xml. Loading resources.xml values");
                maxFinal = maxResources;
            }
        } else if (maxResources < 0) {
            maxFinal = n;
        } else if (n < maxResources) {
            maxFinal = n;
        } else {
            LOGGER.warn("resources.xml MaxPort is more restrictive than project.xml. Loading resources.xml values");
            maxFinal = maxResources;
        }
        LOGGER.info("NIO Min Port: " + minFinal);
        LOGGER.info("NIO MAX Port: " + maxFinal);
        config.setMinPort(minFinal);
        config.setMaxPort(maxFinal);
        String remoteExecutionCommand = propsResources.getRemoteExecutionCommand();
        if (remoteExecutionCommand == null || remoteExecutionCommand.isEmpty()) {
            remoteExecutionCommand = "ssh";
        }
        if (!NIOConfiguration.AVAILABLE_REMOTE_EXECUTION_COMMANDS.contains(remoteExecutionCommand)) {
            throw new ConstructConfigurationException("Invalid remote execution command on resources file");
        }
        config.setRemoteExecutionCommand(remoteExecutionCommand);
        return config;
    }

    @Override
    public COMPSsWorker initWorker(Configuration config) {
        NIOConfiguration nioCfg = (NIOConfiguration)config;
        LOGGER.debug("Init NIO Worker Node named " + nioCfg.getHost());
        NIOWorkerNode worker = new NIOWorkerNode(nioCfg, this);
        NODES.add(worker);
        return worker;
    }

    @Override
    public boolean isPersistentCEnabled() {
        return this.persistentC;
    }

    public void removedNode(NIOWorkerNode worker) {
        LOGGER.debug("Remove worker " + worker.getName());
        NODES.remove(worker);
    }

    @Override
    public void stop() {
        LOGGER.debug("NIO Adaptor stopping workers...");
        HashSet<NIOWorkerNode> workers = new HashSet<NIOWorkerNode>();
        workers.addAll(NODES);
        Semaphore sem = new Semaphore(0);
        ShutdownListener sl = new ShutdownListener(sem);
        for (NIOWorkerNode worker : workers) {
            LOGGER.debug("- Stopping worker " + worker.getName());
            sl.addOperation();
            worker.stop(sl);
        }
        LOGGER.debug("- Waiting for workers to shutdown...");
        sl.enable();
        try {
            sem.acquire();
        }
        catch (Exception e) {
            LOGGER.error("ERROR: Exception raised on worker shutdown");
        }
        LOGGER.debug("- Workers stopped");
        LOGGER.debug("- Shutting down TM...");
        TM.shutdown(null);
        LOGGER.debug("NIO Adaptor stop completed!");
    }

    protected static void submitTask(NIOJob job) throws Exception {
        LOGGER.debug("NIO submitting new job " + job.getJobId());
        Resource res = job.getResource();
        NIOWorkerNode worker = (NIOWorkerNode)res.getNode();
        List<MultiURI> obsoletes = res.pollObsoletes();
        LinkedList<String> obsoleteRenamings = new LinkedList<String>();
        for (MultiURI u : obsoletes) {
            obsoleteRenamings.add(u.getPath());
        }
        RUNNING_JOBS.put(job.getJobId(), job);
        worker.submitTask(job, obsoleteRenamings);
    }

    protected static void cancelTask(NIOJob job) throws Exception {
        LOGGER.debug("NIO cancelling running job " + job.getJobId());
        Resource res = job.getResource();
        NIOWorkerNode worker = (NIOWorkerNode)res.getNode();
        worker.cancelTask(job);
    }

    @Override
    public void receivedNewTask(NIONode master, NIOTask t, List<String> obsoleteFiles) {
    }

    @Override
    public void cancelRunningTask(NIONode node, int jobId) {
    }

    @Override
    public void receivedNewDataFetchOrder(NIOParam data, int transferId) {
    }

    @Override
    public void setMaster(NIONode master) {
    }

    @Override
    public boolean isMyUuid(String uuid, String nodeName) {
        return false;
    }

    @Override
    public void setWorkerIsReady(String nodeName) {
        LOGGER.info("Notifying that worker is ready '" + nodeName + "'");
        WorkerStarter ws = WorkerStarter.getWorkerStarter(nodeName);
        if (ws != null) {
            ws.setWorkerIsReady();
        } else {
            LOGGER.warn("WARN: worker starter for worker " + nodeName + " is null.");
        }
    }

    @Override
    public final void receivedNIOTaskDone(Connection c, NIOTaskResult tr, boolean successful, Exception e) {
        NIOJob nj;
        int jobId = tr.getJobId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received Task done message for Job " + jobId);
        }
        if ((nj = (NIOJob)RUNNING_JOBS.remove(jobId)) != null) {
            int taskId = nj.getTaskId();
            List<DataType> taskResultTypes = tr.getParamTypes();
            block3: for (int i = 0; i < taskResultTypes.size(); ++i) {
                DataType newType = taskResultTypes.get(i);
                switch (newType) {
                    case PSCO_T: 
                    case EXTERNAL_PSCO_T: {
                        String pscoId = (String)tr.getParamValue(i);
                        DependencyParameter dp = (DependencyParameter)nj.getTaskParams().getParameters().get(i);
                        this.updateParameter(newType, pscoId, dp);
                        continue block3;
                    }
                }
            }
            JobHistory prevJobHistory = nj.getHistory();
            nj.taskFinished(successful, e);
            this.retrieveAdditionalJobFiles(c, successful, jobId, taskId, prevJobHistory);
        }
        c.finishConnection();
    }

    private void produceFailOnTask(NIOTask task, List<String> obsolete) {
        NIOJob nj;
        int jobId = task.getJobId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received Task done message for Job " + jobId);
        }
        if ((nj = (NIOJob)RUNNING_JOBS.remove(jobId)) != null) {
            int taskId = nj.getTaskId();
            JobHistory prevJobHistory = nj.getHistory();
            nj.taskFinished(false, null);
            this.generateFailedJobFiles(jobId, taskId, prevJobHistory, "Error sending new task command");
        }
    }

    private void generateFailedJobFiles(int jobId, int taskId, JobHistory history, String message) {
        String jobOut = JOBS_DIR + "job" + jobId + "_" + (Object)((Object)history) + ".out";
        String jobErr = JOBS_DIR + "job" + jobId + "_" + (Object)((Object)history) + ".err";
        this.writeJobFile(jobOut, message);
        this.writeJobFile(jobErr, message);
    }

    private void writeJobFile(String taskFileName, String message) {
        File taskFile = new File(taskFileName);
        if (!taskFile.exists()) {
            try (FileOutputStream stream = new FileOutputStream(taskFile);){
                stream.write(message.getBytes());
                stream.close();
            }
            catch (IOException ioe) {
                LOGGER.error("IOException writing file: " + taskFile, (Throwable)ioe);
            }
        }
    }

    protected void retrieveAdditionalJobFiles(Connection connection, boolean success, int jobId, int taskId, JobHistory history) {
        if (WORKER_DEBUG || !success) {
            String jobOut = JOBS_DIR + "job" + jobId + "_" + (Object)((Object)history) + ".out";
            String jobErr = JOBS_DIR + "job" + jobId + "_" + (Object)((Object)history) + ".err";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Requesting JobOut " + jobOut + " for Task " + taskId);
                LOGGER.debug("Requesting JobErr " + jobErr + " for Task " + taskId);
            }
            connection.receiveDataFile(jobOut);
            connection.receiveDataFile(jobErr);
        }
    }

    private void updateParameter(DataType newType, String pscoId, DependencyParameter dp) {
        DataType previousType = dp.getType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updating parameter " + dp.getDataTarget() + " from type " + (Object)((Object)previousType) + " to type " + (Object)((Object)newType) + " with id " + pscoId);
        }
        switch (previousType) {
            case PSCO_T: 
            case EXTERNAL_PSCO_T: {
                if (previousType.equals((Object)newType)) {
                    dp.setDataTarget(pscoId);
                    break;
                }
                LOGGER.warn("WARN: Cannot update parameter " + dp.getDataTarget() + " because types are not compatible");
                break;
            }
            default: {
                this.registerUpdatedParameter(newType, pscoId, dp);
            }
        }
    }

    private void registerUpdatedParameter(DataType newType, String pscoId, DependencyParameter dp) {
        String renaming = dp.getDataTarget();
        switch (newType) {
            case PSCO_T: {
                Comm.registerPSCO(renaming, pscoId);
                break;
            }
            case EXTERNAL_PSCO_T: {
                if (renaming.contains("/")) {
                    renaming = renaming.substring(renaming.lastIndexOf(47) + 1);
                }
                Comm.registerExternalPSCO(renaming, pscoId);
                break;
            }
            default: {
                LOGGER.warn("WARN: Invalid new type " + (Object)((Object)newType) + " for parameter " + renaming);
            }
        }
        dp.setType(newType);
        dp.setDataTarget(pscoId);
    }

    public void registerCopy(Copy c) {
        for (EventListener el : c.getEventListeners()) {
            Integer groupId = el.getId();
            LinkedList<Copy> copies = GROUP_TO_COPY.get(groupId);
            if (copies == null) {
                copies = new LinkedList();
                GROUP_TO_COPY.put(groupId, copies);
            }
            copies.add(c);
        }
    }

    @Override
    protected void handleDataToSendNotAvailable(Connection c, NIOData d) {
        c.finishConnection();
    }

    @Override
    public void handleRequestedDataNotAvailableError(List<DataRequest> failedRequests, String dataId) {
        for (DataRequest dr : failedRequests) {
            MasterDataRequest mdr = (MasterDataRequest)dr;
            Copy c = (Copy)mdr.getOperation();
            c.getSourceData().finishedCopy(c);
            c.end(OperationEndState.OP_FAILED);
        }
    }

    @Override
    public void receivedValue(Transfer.Destination type, String dataId, Object object, List<DataRequest> achievedRequests) {
        for (DataRequest dr : achievedRequests) {
            MasterDataRequest mdr = (MasterDataRequest)dr;
            Copy c = (Copy)mdr.getOperation();
            DataLocation actualLocation = c.getSourceData().finishedCopy(c);
            LogicalData tgtData = c.getTargetData();
            if (tgtData != null) {
                tgtData.addLocation(actualLocation);
                if (object != null) {
                    tgtData.setValue(object);
                }
            }
            c.end(OperationEndState.OP_OK);
        }
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitDataTransferEvent("0");
        }
    }

    @Override
    public void copiedData(int transferGroupId) {
        LOGGER.debug("Notifying copied Data to master");
        LinkedList<Copy> copies = GROUP_TO_COPY.remove(transferGroupId);
        if (copies == null) {
            LOGGER.debug("No copies to process");
            return;
        }
        for (Copy c : copies) {
            LOGGER.debug("Treating copy " + c.getName());
            if (!c.isRegistered()) {
                LOGGER.debug("No registered copy " + c.getName());
                continue;
            }
            DataLocation actualLocation = c.getSourceData().finishedCopy(c);
            if (actualLocation != null) {
                LOGGER.debug("Actual Location " + actualLocation.getPath());
            } else {
                LOGGER.debug("Actual Location is null");
            }
            LogicalData tgtData = c.getTargetData();
            if (tgtData != null) {
                LOGGER.debug("targetData is not null");
                switch (actualLocation.getType()) {
                    case PERSISTENT: {
                        LOGGER.debug("Persistent location no need to update location for " + tgtData.getName());
                        break;
                    }
                    case BINDING: 
                    case PRIVATE: {
                        LOGGER.debug("Adding location:" + actualLocation.getPath() + " to " + tgtData.getName());
                        tgtData.addLocation(actualLocation);
                        break;
                    }
                    case SHARED: {
                        LOGGER.debug("Shared location no need to update location for " + tgtData.getName());
                    }
                }
                LOGGER.debug("Locations for " + tgtData.getName() + " are: " + tgtData.getURIs());
                continue;
            }
            LOGGER.warn("No target Data defined for copy " + c.getName());
        }
    }

    @Override
    public List<DataOperation> getPending() {
        return new LinkedList<DataOperation>();
    }

    @Override
    public Object getObject(String name) throws SerializedObjectException {
        LogicalData ld = Comm.getData(name);
        Object o = ld.getValue();
        if (o == null) {
            for (MultiURI loc : ld.getURIs()) {
                if (loc.getProtocol().equals((Object)ProtocolType.OBJECT_URI) || !loc.getHost().equals(Comm.getAppHost())) continue;
                throw new SerializedObjectException(name);
            }
        }
        return o;
    }

    @Override
    public String getObjectAsFile(String name) {
        LogicalData ld = Comm.getData(name);
        for (MultiURI loc : ld.getURIs()) {
            if (loc.getProtocol().equals((Object)ProtocolType.OBJECT_URI) || !loc.getHost().equals(Comm.getAppHost())) continue;
            return loc.getPath();
        }
        return null;
    }

    @Override
    public String getWorkingDir() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopSubmittedJobs() {
        ConcurrentMap<Integer, NIOJob> concurrentMap = RUNNING_JOBS;
        synchronized (concurrentMap) {
            for (Job job : RUNNING_JOBS.values()) {
                try {
                    job.cancelJob();
                }
                catch (Exception e) {
                    LOGGER.error(TERM_ERR, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void completeMasterURI(MultiURI u) {
        u.setInternalURI(ID, new NIOUri(this.masterNode, u.getPath(), u.getProtocol()));
    }

    public void requestData(Copy c, DataType paramType, NIOData d, String path) {
        MasterDataRequest dr = new MasterDataRequest(c, paramType, d, path);
        this.addTransferRequest(dr);
        this.requestTransfers();
    }

    public void shuttingDown(NIOWorkerNode worker, Connection c, ShutdownListener listener) {
        STOPPING_NODES.put(c, new ClosingWorker(worker, listener));
    }

    public void shuttingDownEM(NIOWorkerNode worker, Connection c, ExecutorShutdownListener listener) {
        STOPPING_EXECUTORS.put(c, new ClosingExecutor(listener));
    }

    @Override
    public void shutdownNotification(Connection c) {
        ClosingWorker closing = STOPPING_NODES.remove(c);
        NIOWorkerNode worker = closing.worker;
        this.removedNode(worker);
        ShutdownListener listener = closing.listener;
        listener.notifyEnd();
    }

    @Override
    public void shutdown(Connection closingConnection) {
    }

    @Override
    public void shutdownExecutionManager(Connection closingConnection) {
    }

    @Override
    public void shutdownExecutionManagerNotification(Connection c) {
        ClosingExecutor closing = STOPPING_EXECUTORS.remove(c);
        ExecutorShutdownListener listener = closing.listener;
        listener.notifyEnd();
    }

    @Override
    public void waitUntilTracingPackageGenerated() {
        try {
            this.tracingGeneration.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for package generation");
        }
    }

    @Override
    public void notifyTracingPackageGeneration() {
        this.tracingGeneration.release();
    }

    @Override
    public void waitUntilWorkersDebugInfoGenerated() {
        try {
            this.workersDebugInfo.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for package generation");
        }
    }

    @Override
    public void notifyWorkersDebugInfoGeneration() {
        this.workersDebugInfo.release();
    }

    @Override
    public void generateWorkersDebugInfo(Connection c) {
        c.sendCommand(new CommandWorkerDebugFilesDone());
        c.finishConnection();
    }

    @Override
    public void increaseResources(MethodResourceDescription description) {
    }

    @Override
    public void reduceResources(MethodResourceDescription description) {
    }

    @Override
    public void performedResourceUpdate(Connection c) {
        c.finishConnection();
        Semaphore sem = PENDING_MODIFICATIONS.get(c);
        if (sem != null) {
            sem.release();
        }
    }

    public void registerPendingResourceUpdateConfirmation(Connection c, Semaphore sem) {
        PENDING_MODIFICATIONS.put(c, sem);
    }

    @Override
    public void receivedBindingObjectAsFile(String filename, String target) {
        if (filename.contains("#")) {
            filename = BindingObject.generate(filename).getId();
        }
        if (target.contains("#")) {
            BindingObject bo = BindingObject.generate(target);
            BindingDataManager.loadFromFile(bo.getName(), filename, bo.getType(), bo.getElements());
        } else {
            ErrorManager.error("Incorrect target format for binding object.(" + target + ")");
        }
    }

    @Override
    protected String getPossiblyRenamedFileName(File originalFile, NIOData d) {
        return Comm.getAppHost().getCompleteRemotePath(DataType.FILE_T, d.getDataMgmtId()).getPath();
    }

    @Override
    public void unhandeledError(Connection c) {
        LOGGER.fatal("Unhandeled error in connection " + c.hashCode() + ". Stopping the runtime...");
        ErrorManager.fatal("Unhandeled error in connection " + c.hashCode() + ".");
    }

    @Override
    public void handleCancellingTaskCommandError(Connection c, CommandCancelTask commandCancelTask) {
        if (commandCancelTask.canRetry()) {
            commandCancelTask.increaseRetries();
            this.resendCommand((NIONode)c.getNode(), commandCancelTask);
        } else {
            LOGGER.warn("Error sending cancel tasks after retries. Nothing else to do.");
        }
    }

    @Override
    public void handleDataReceivedCommandError(Connection c, CommandDataReceived commandDataReceived) {
        LOGGER.warn("Error receiving task done command. Not handeled");
    }

    @Override
    public void handleExecutorShutdownCommandError(Connection c, CommandExecutorShutdown commandExecutorShutdown) {
        LOGGER.error("Error sending Executor Shutdown command. Not handeled");
        this.unhandeledError(c);
    }

    @Override
    public void handleExecutorShutdownCommandACKError(Connection c, CommandExecutorShutdownACK commandExecutorShutdownACK) {
        LOGGER.warn("Error receiving executor shutdown ACK. Not handeled");
    }

    @Override
    public void handleTaskDoneCommandError(Connection c, CommandNIOTaskDone commandNIOTaskDone) {
        LOGGER.warn("Error receiving task done notification. Not handeled");
    }

    @Override
    public void handleNewTaskCommandError(Connection c, CommandNewTask commandNewTask) {
        if (commandNewTask.canRetry()) {
            commandNewTask.increaseRetries();
            this.resendCommand((NIONode)c.getNode(), commandNewTask);
        } else {
            this.produceFailOnTask(commandNewTask.getTask(), commandNewTask.getObsolete());
        }
    }

    @Override
    public void handleShutdownCommandError(Connection c, CommandShutdown commandShutdown) {
        LOGGER.error("Error sending Executor Shutdown command. Not handeled");
        this.unhandeledError(c);
    }

    @Override
    public void handleShutdownACKCommandError(Connection c, CommandShutdownACK commandShutdownACK) {
        LOGGER.warn("Error receiving shutdown ACK. Not handeled");
    }

    @Override
    public void handleTracingGenerateDoneCommandError(Connection c, CommandGenerateDone commandGenerateDone) {
        LOGGER.warn("Error receiving tracing generate done. Not handeled");
    }

    @Override
    public void handleTracingGenerateCommandError(Connection c, CommandGeneratePackage commandGeneratePackage) {
        LOGGER.error("Error sending tracing generate command. Not handeled");
        this.unhandeledError(c);
    }

    @Override
    public void handleGenerateWorkerDebugCommandError(Connection c, CommandGenerateWorkerDebugFiles commandGenerateWorkerDebugFiles) {
        LOGGER.error("Error sending generate worker debug command. Not handeled");
        this.unhandeledError(c);
    }

    @Override
    public void handleGenerateWorkerDebugDoneCommandError(Connection c, CommandWorkerDebugFilesDone commandWorkerDebugFilesDone) {
        LOGGER.warn("Error receiving generate worker debug done. Not handeled");
    }

    @Override
    public void receivedRemoveObsoletes(NIONode node, List<String> obsolete) {
    }

    @Override
    public void handleRemoveObsoletesCommandError(Connection c, CommandRemoveObsoletes commandRemoveObsoletes) {
        if (commandRemoveObsoletes.canRetry()) {
            commandRemoveObsoletes.increaseRetries();
            this.resendCommand((NIONode)c.getNode(), commandRemoveObsoletes);
        } else {
            LOGGER.warn("Error sending command remove obsoletes after retries. Nothing else to do.");
        }
    }

    static {
        int masterPort;
        LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
        WORKER_DEBUG = LogManager.getLogger("es.bsc.compss.Worker").isDebugEnabled();
        JOBS_DIR = System.getProperty("compss.appLogDir") + "jobs" + File.separator;
        NODES = new HashSet<NIOWorkerNode>();
        RUNNING_JOBS = new ConcurrentHashMap<Integer, NIOJob>();
        GROUP_TO_COPY = new HashMap<Integer, LinkedList<Copy>>();
        STOPPING_NODES = new HashMap<Connection, ClosingWorker>();
        STOPPING_EXECUTORS = new HashMap<Connection, ClosingExecutor>();
        PENDING_MODIFICATIONS = new HashMap<Connection, Semaphore>();
        String masterPortProp = System.getProperty("compss.masterPort");
        if (masterPortProp != null && !masterPortProp.isEmpty()) {
            masterPort = Integer.valueOf(masterPortProp);
        } else {
            int random = new Random().nextInt(1000);
            masterPort = 43000 + random;
        }
        MASTER_PORT = masterPort;
    }

    private class ClosingExecutor {
        private final ExecutorShutdownListener listener;

        public ClosingExecutor(ExecutorShutdownListener l) {
            this.listener = l;
        }
    }

    private class ClosingWorker {
        private final NIOWorkerNode worker;
        private final ShutdownListener listener;

        public ClosingWorker(NIOWorkerNode w, ShutdownListener l) {
            this.worker = w;
            this.listener = l;
        }
    }
}

