/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.exceptions.ExternalPropertyException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ExternalStreamHandler {
    public static String getExternalStreamProperty(String pythonInterpreter, String fileName, String property) throws ExternalPropertyException {
        StringBuilder pythonCall = new StringBuilder();
        pythonCall.append("import pickle;");
        pythonCall.append("pickle_in=open('").append(fileName).append("', 'rb');");
        pythonCall.append("pickle_in.seek(4);");
        pythonCall.append("obj = pickle.load(pickle_in);");
        pythonCall.append("print(obj.").append(property).append(");");
        pythonCall.append("pickle_in.close()");
        pythonCall.append("");
        String[] cmd = new String[]{pythonInterpreter, "-c", pythonCall.toString()};
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.environment().remove("LD_PRELOAD");
        String propertyValue = null;
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                String errorMsg = "Process exit value = " + exitValue + "\n";
                String internalError = ExternalStreamHandler.getStreamContent(process.getErrorStream());
                errorMsg = errorMsg + internalError;
                throw new ExternalPropertyException(errorMsg);
            }
            propertyValue = ExternalStreamHandler.getStreamContent(process.getInputStream());
        }
        catch (IOException ioe) {
            throw new ExternalPropertyException(ioe);
        }
        catch (InterruptedException ie) {
            throw new ExternalPropertyException(ie);
        }
        return propertyValue;
    }

    private static String getStreamContent(InputStream is) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        return content.toString();
    }
}

