/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.commands.RetriableCommand;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandCancelTask
extends RetriableCommand {
    private int jobId;

    public CommandCancelTask() {
    }

    public CommandCancelTask(int jobId) {
        this.jobId = jobId;
    }

    @Override
    public void handle(NIOAgent agent, Connection c) {
        agent.cancelRunningTask((NIONode)c.getNode(), this.jobId);
        c.finishConnection();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.jobId = (Integer)in.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.jobId);
    }

    public String toString() {
        return "New Task with job ID " + this.jobId;
    }

    @Override
    public void error(NIOAgent agent, Connection c) {
        agent.handleCancellingTaskCommandError(c, this);
    }
}

