/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.BinaryImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;

public class BinaryDefinition
extends ImplementationDefinition<MethodResourceDescription> {
    private final String binary;
    private final String workingDir;
    private final boolean failByEV;

    public BinaryDefinition(String signature, String binary, String workingDir, boolean failByEV, MethodResourceDescription implConstraints) {
        super(signature, implConstraints);
        this.binary = binary;
        this.workingDir = workingDir;
        this.failByEV = failByEV;
    }

    @Override
    public Implementation getImpl(int coreId, int implId) {
        return new BinaryImplementation(this.binary, this.workingDir, this.failByEV, coreId, implId, this.getSignature(), (MethodResourceDescription)this.getConstraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Binary Implementation \n");
        sb.append("\t Signature: ").append(this.getSignature()).append("\n");
        sb.append("\t Binary: ").append(this.binary).append("\n");
        sb.append("\t IO: ").append(!((MethodResourceDescription)this.getConstraints()).usesCPUs()).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        sb.append("\t Constraints: ").append(this.getConstraints());
        return sb.toString();
    }
}

