/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.distrostreamlib.api.files;

import es.bsc.distrostreamlib.api.impl.DistroStreamImpl;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.exceptions.BackendException;
import es.bsc.distrostreamlib.exceptions.RegistrationException;
import es.bsc.distrostreamlib.requests.PollRequest;
import es.bsc.distrostreamlib.types.ConsumerMode;
import es.bsc.distrostreamlib.types.StreamType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDistroStream
extends DistroStreamImpl<String> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.distroStreamLib.stream.FileDistroStream");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String WARN_PUBLISH = "WARN: Unnecessary call on publish on FileDistroStream";
    private static final ConsumerMode DEFAULT_CONSUMER_MODE = ConsumerMode.AT_MOST_ONCE;
    private String baseDir;

    public FileDistroStream() {
    }

    public FileDistroStream(String baseDir) throws RegistrationException {
        super(null, StreamType.FILE, DEFAULT_CONSUMER_MODE, Arrays.asList(baseDir));
        this.baseDir = baseDir;
    }

    public FileDistroStream(String alias, String baseDir) throws RegistrationException {
        super(alias, StreamType.FILE, DEFAULT_CONSUMER_MODE, Arrays.asList(baseDir));
        this.baseDir = baseDir;
    }

    public FileDistroStream(String baseDir, ConsumerMode mode) throws RegistrationException {
        super(null, StreamType.FILE, mode, Arrays.asList(baseDir));
        this.baseDir = baseDir;
    }

    public FileDistroStream(String alias, String baseDir, ConsumerMode mode) throws RegistrationException {
        super(alias, StreamType.FILE, mode, Arrays.asList(baseDir));
        this.baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public final void publish(String message) throws BackendException {
        LOGGER.warn(WARN_PUBLISH);
    }

    @Override
    public final void publish(List<String> messages) throws BackendException {
        LOGGER.warn(WARN_PUBLISH);
    }

    @Override
    public final List<String> poll() throws BackendException {
        return this.pollFiles();
    }

    @Override
    public final List<String> poll(long timeout) throws BackendException {
        LOGGER.warn("WARN: Ignoring timeout for FileDistroStreams");
        return this.pollFiles();
    }

    private List<String> pollFiles() throws BackendException {
        LOGGER.info("Polling new stream items...");
        PollRequest req = new PollRequest(this.id);
        DistroStreamClient.request(req);
        req.waitProcessed();
        int error = req.getErrorCode();
        if (error != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("ERROR: Cannot poll stream").append("\n");
            sb.append("  - Error Code: ").append(error).append("\n");
            sb.append("  - Nested Error Message: ").append(req.getErrorMessage()).append("\n");
            throw new BackendException(sb.toString());
        }
        String response = req.getResponseMessage();
        if (DEBUG) {
            LOGGER.debug("Retrieved stream items: " + response);
        }
        if (response != null && !response.isEmpty()) {
            return Arrays.asList(response.split(" "));
        }
        return new ArrayList<String>();
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        super.readExternal(oi);
        this.baseDir = (String)oi.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.baseDir);
    }
}

