/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.ContainerDescription;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ContainerImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 7;
    public static final String SIGNATURE = "container.CONTAINER";
    private ContainerDescription container;
    private ContainerExecutionType internalExecutionType;
    private String internalBinary;
    private String internalFunc;
    private String workingDir;
    private boolean failByEV;

    public ContainerImplementation() {
    }

    public ContainerImplementation(ContainerExecutionType internalExecutionType, String internalFunc, String internalBinary, String workingDir, boolean failByEV, ContainerDescription container, Integer coreId, Integer implementationId, String signature, MethodResourceDescription annot) {
        super(coreId, implementationId, signature, annot);
        this.internalExecutionType = internalExecutionType;
        this.internalBinary = internalBinary;
        this.internalFunc = internalFunc;
        this.workingDir = workingDir;
        this.failByEV = failByEV;
        this.container = container;
    }

    public ContainerExecutionType getInternalExecutionType() {
        return this.internalExecutionType;
    }

    public String getInternalBinary() {
        return this.internalBinary;
    }

    public String getInternalFunction() {
        return this.internalFunc;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    public ContainerDescription getContainer() {
        return this.container;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.CONTAINER;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[CONTAINER=").append(this.container);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ImplementationDefinition<?> getDefinition() {
        return new ContainerDefinition(this.getSignature(), this.internalExecutionType, this.internalFunc, this.internalBinary, this.workingDir, this.failByEV, this.container, this.getRequirements());
    }

    @Override
    public String toString() {
        return "ContainerImplementation [container=" + this.container + ", internalExecutionType=" + (Object)((Object)this.internalExecutionType) + ", binary=" + this.internalBinary + ", pyFunc=" + this.internalFunc + "]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.internalExecutionType = (ContainerExecutionType)((Object)in.readObject());
        this.internalFunc = (String)in.readObject();
        this.internalBinary = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.failByEV = in.readBoolean();
        this.container = (ContainerDescription)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.internalExecutionType);
        out.writeObject(this.internalFunc);
        out.writeObject(this.internalBinary);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.failByEV);
        out.writeObject(this.container);
    }

    public static enum ContainerExecutionType {
        CET_PYTHON,
        CET_BINARY;

    }
}

