/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.DecafImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;

public class DecafDefinition
extends ImplementationDefinition<MethodResourceDescription> {
    private final String dfScript;
    private final String dfExecutor;
    private final String dfLib;
    private final String workingDir;
    private final String mpiRunner;
    private final boolean failByEV;

    public DecafDefinition(String signature, String dfScript, String dfExecutor, String dfLib, String workingDir, String mpiRunner, boolean failByEV, MethodResourceDescription implConstraints) {
        super(signature, implConstraints);
        this.dfScript = dfScript;
        this.dfExecutor = dfExecutor;
        this.dfLib = dfLib;
        this.workingDir = workingDir;
        this.mpiRunner = mpiRunner;
        this.failByEV = failByEV;
    }

    @Override
    public Implementation getImpl(int coreId, int implId) {
        return new DecafImplementation(this.dfScript, this.dfExecutor, this.dfLib, this.workingDir, this.mpiRunner, this.failByEV, coreId, implId, this.getSignature(), (MethodResourceDescription)this.getConstraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DECAF Implementation \n");
        sb.append("\t Signature: ").append(this.getSignature()).append("\n");
        sb.append("\t IO: ").append(!((MethodResourceDescription)this.getConstraints()).usesCPUs()).append("\n");
        sb.append("\t Decaf script: ").append(this.dfScript).append("\n");
        sb.append("\t Decaf executor: ").append(this.dfExecutor).append("\n");
        sb.append("\t Decaf lib: ").append(this.dfLib).append("\n");
        sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        sb.append("\t Constraints: ").append(this.getConstraints());
        return sb.toString();
    }
}

