/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.commands.RetriableCommand;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class CommandRemoveObsoletes
extends RetriableCommand {
    private List<String> obsolete;

    public CommandRemoveObsoletes() {
    }

    public CommandRemoveObsoletes(List<String> obsolete) {
        this.obsolete = obsolete;
    }

    @Override
    public void handle(NIOAgent agent, Connection c) {
        agent.receivedRemoveObsoletes((NIONode)c.getNode(), this.obsolete);
        c.finishConnection();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.obsolete = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.obsolete);
    }

    public String toString() {
        return "Remove obsoletes " + this.obsolete;
    }

    @Override
    public void error(NIOAgent agent, Connection c) {
        agent.handleRemoveObsoletesCommandError(c, this);
    }

    public List<String> getObsolete() {
        return this.obsolete;
    }
}

