/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.nio.master.utils.NIOParamFactory;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import java.util.List;

public class NIOJob
extends Job<NIOWorkerNode> {
    protected final List<String> slaveWorkersNodeNames;

    public NIOJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        super(taskId, taskParams, impl, res, listener);
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
    }

    public TaskType getType() {
        return TaskType.METHOD;
    }

    public String getHostName() {
        return this.worker.getName();
    }

    public void submit() throws Exception {
        LOGGER.info("Submit NIOJob with ID " + this.jobId);
        NIOAdaptor.submitTask(this);
    }

    public void cancelJob() throws Exception {
        LOGGER.info("Stopping NIOJob with ID " + this.jobId);
        NIOAdaptor.cancelTask(this);
    }

    public NIOTask prepareJob() {
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        switch (absMethodImpl.getMethodType()) {
            case METHOD: {
                MethodDefinition methodImpl = (MethodDefinition)absMethodImpl.getDescription().getDefinition();
                String methodName = methodImpl.getAlternativeMethodName();
                if (methodName != null && !methodName.isEmpty()) break;
                methodImpl.setAlternativeMethodName(this.taskParams.getName());
                break;
            }
            case MULTI_NODE: {
                MultiNodeDefinition multiNodeImpl = (MultiNodeDefinition)absMethodImpl.getDescription().getDefinition();
                String multiNodeMethodName = multiNodeImpl.getMethodName();
                if (multiNodeMethodName != null && !multiNodeMethodName.isEmpty()) break;
                multiNodeImpl.setMethodName(this.taskParams.getName());
                break;
            }
        }
        LinkedList<NIOParam> params = this.addParams();
        int numParams = params.size() - this.taskParams.getNumReturns();
        String parallelismSource = this.taskParams.getParallelismSource();
        NIOTask nt = new NIOTask(this.getLang(), DEBUG, absMethodImpl, parallelismSource, this.taskParams.hasTargetObject(), this.taskParams.getNumReturns(), params, numParams, absMethodImpl.getRequirements(), this.slaveWorkersNodeNames, this.taskId, this.impl.getTaskType(), this.jobId, this.history, this.transferId, this.getOnFailure(), this.getTimeOut());
        return nt;
    }

    private LinkedList<NIOParam> addParams() {
        LinkedList<NIOParam> params = new LinkedList<NIOParam>();
        for (Parameter param : this.taskParams.getParameters()) {
            params.add(NIOParamFactory.fromParameter(param, (NIOWorkerNode)this.getResourceNode(), this.taskParams.isReplicated()));
        }
        return params;
    }

    public void taskFinished(boolean successful, Exception e) {
        if (successful) {
            this.listener.jobCompleted((Job)this);
        } else if (e instanceof COMPSsException) {
            this.listener.jobFailed((Job)this, JobEndStatus.EXCEPTION, (COMPSsException)e);
        } else {
            this.listener.jobFailed((Job)this, JobEndStatus.EXECUTION_FAILED, null);
        }
    }

    public String toString() {
        AbstractMethodImplementation method = (AbstractMethodImplementation)this.impl;
        String definition = method.getMethodDefinition();
        String methodName = this.taskParams.getName();
        return "NIOJob JobId" + this.jobId + " for method " + methodName + " with definition " + definition;
    }
}

