/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.types;

import es.bsc.compss.util.types.RowThreadIdComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RowFile {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    private static String cpuSizeIdentifier = "LEVEL CPU SIZE";
    private static String nodeSizeIdentifier = "LEVEL NODE SIZE";
    private static String threadSizeIdentifier = "LEVEL THREAD SIZE";
    private List<String>[] information = new List[3];

    public RowFile(File rowFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(rowFile));
        String line = "";
        RowBlock reading = RowBlock.CPUS;
        Arrays.setAll(this.information, element -> new ArrayList());
        while ((line = br.readLine()) != null) {
            if (line.isEmpty()) continue;
            if (line.startsWith(cpuSizeIdentifier)) {
                reading = RowBlock.CPUS;
                continue;
            }
            if (line.startsWith(nodeSizeIdentifier)) {
                reading = RowBlock.NODES;
                continue;
            }
            if (line.startsWith(threadSizeIdentifier)) {
                reading = RowBlock.THREADS;
                continue;
            }
            if (line.startsWith(cpuSizeIdentifier)) {
                reading = RowBlock.CPUS;
                continue;
            }
            this.information[reading.ordinal()].add(line);
        }
        br.close();
    }

    public void mergeAgentRow(RowFile fileToMerge, int agentId) throws Exception {
        List<String> cpus = this.information[RowBlock.CPUS.ordinal()];
        List<String> threads = this.information[RowBlock.THREADS.ordinal()];
        List<String> cpusToMerge = fileToMerge.information[RowBlock.CPUS.ordinal()];
        List<String> threadsToMerge = fileToMerge.information[RowBlock.THREADS.ordinal()];
        int previousCpuNum = cpus.size();
        for (String cp : cpusToMerge) {
            String newCp = Integer.toString(previousCpuNum) + cp.substring(cp.indexOf("."));
            cpus.add(newCp);
            ++previousCpuNum;
        }
        for (String th : threadsToMerge) {
            String newTh;
            if (th.contains("(")) {
                int prefixIndex = th.indexOf("(") + 1;
                int sufixIndex = th.indexOf(")");
                String oldThId = th.substring(prefixIndex, sufixIndex);
                CharSequence[] oldIdValues = oldThId.split("\\.");
                oldIdValues[0] = Integer.toString(agentId);
                String newThId = String.join((CharSequence)".", oldIdValues);
                newTh = th.substring(0, prefixIndex) + newThId + th.substring(sufixIndex, th.length());
            } else if (th.startsWith("THREAD ")) {
                CharSequence[] oldIdValues = th.split("\\.");
                oldIdValues[0] = "THREAD " + Integer.toString(agentId);
                newTh = String.join((CharSequence)".", oldIdValues);
            } else {
                throw new Exception("Thread id in .row file with unknown format, don't know how to merge: " + th.toString());
            }
            threads.add(newTh);
        }
    }

    public void updateRowLabels(List<String> labelList) {
        ArrayList<String> newThreads = new ArrayList<String>();
        for (String label : labelList) {
            newThreads.add(label);
        }
        newThreads.sort(new RowThreadIdComparator());
        this.information[RowBlock.THREADS.ordinal()] = newThreads;
    }

    public void printInfo(File outputFile) throws IOException {
        int i;
        if (outputFile.exists()) {
            outputFile.delete();
            outputFile.createNewFile();
        }
        PrintWriter rowWriter = new PrintWriter(new FileWriter(outputFile.getAbsolutePath(), true));
        List<String> cpus = this.information[RowBlock.CPUS.ordinal()];
        List<String> nodes = this.information[RowBlock.NODES.ordinal()];
        List<String> threads = this.information[RowBlock.THREADS.ordinal()];
        rowWriter.println(cpuSizeIdentifier + " " + cpus.size());
        for (i = 0; i < cpus.size(); ++i) {
            rowWriter.println(cpus.get(i));
        }
        rowWriter.println();
        rowWriter.println(nodeSizeIdentifier + " " + nodes.size());
        for (i = 0; i < nodes.size(); ++i) {
            rowWriter.println(nodes.get(i));
        }
        rowWriter.println();
        rowWriter.println(threadSizeIdentifier + " " + threads.size());
        for (i = 0; i < threads.size(); ++i) {
            rowWriter.println(threads.get(i));
        }
        rowWriter.println();
        rowWriter.close();
    }

    private static enum RowBlock {
        CPUS,
        NODES,
        THREADS;

    }
}

