/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.cepbatools.extrae.Wrapper;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.tracing.TraceScript;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Tracer {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String ERROR_TRACE_DIR = "ERROR: Cannot create trace directory";
    public static final String TRACE_SUBFOLDER = "trace";
    private static final String TRACER_OUT_FILENAME = "tracer.out";
    private static final String TRACER_ERR_FILENAME = "tracer.err";
    public static final String PACKAGE_SUFFIX = "_compss_trace.tar.gz";
    private static final String EXTRAE_FILE;
    private static final String EXTRAE_OUTPUT_DIR;
    public static final String[] ENVIRONMENT_VARIABLES;
    public static final int EVENT_END = 0;
    private static final AtomicInteger NEXT_HOST_ID;
    public static boolean tracerAlreadyLoaded;
    private static boolean enabled;
    private static String nodeName;
    private static String installDir;
    private static String hostId;
    protected static boolean tracingTaskDependencies;
    private static final Map<String, TraceHost> hostToSlots;
    private static int numPthreadsEnabled;
    private static final HashMap<Integer, ArrayList<Integer>> predecessorsMap;

    public static void init(boolean enabled, int hostId, String nodeName, String installDir, boolean tracingTasks) {
        if (tracerAlreadyLoaded) {
            if (DEBUG) {
                LOGGER.debug("Tracing already initialized.");
            }
            return;
        }
        tracerAlreadyLoaded = true;
        Tracer.enabled = enabled;
        Tracer.nodeName = nodeName;
        Tracer.installDir = installDir;
        if (DEBUG) {
            LOGGER.debug("Initializing tracing: " + (enabled ? "Enabled" : "Disabled"));
        }
        if (enabled) {
            Tracer.hostId = String.valueOf(hostId);
            LOGGER.debug("\t Tracing Host ID: " + Tracer.hostId);
            tracingTaskDependencies = tracingTasks;
            LOGGER.debug("\t Task dependencies: " + (tracingTasks ? "Enabled" : "Disabled"));
            LOGGER.debug("\t Extrae file: " + EXTRAE_FILE);
            LOGGER.debug("\t Tracing Ouput folder: " + EXTRAE_OUTPUT_DIR);
            File traceOutDir = new File(EXTRAE_OUTPUT_DIR);
            if (!traceOutDir.exists() && !new File(EXTRAE_OUTPUT_DIR).mkdir()) {
                ErrorManager.error(ERROR_TRACE_DIR);
            }
            Tracer.setUpWrapper(hostId, hostId + 1);
        }
    }

    public static String getHostID() {
        return hostId;
    }

    public static String getTraceOutPath() {
        return EXTRAE_OUTPUT_DIR + TRACER_OUT_FILENAME;
    }

    public static String getTraceErrPath() {
        return EXTRAE_OUTPUT_DIR + TRACER_ERR_FILENAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUpWrapper(int taskId, int numTasks) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (DEBUG) {
                LOGGER.debug("Initializing extrae Wrapper.");
            }
            Wrapper.SetTaskID(taskId);
            Wrapper.SetNumTasks(numTasks);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean isActivated() {
        return enabled;
    }

    public static boolean isTracingTaskDependencies() {
        return tracingTaskDependencies;
    }

    public static String getExtraeFile() {
        return EXTRAE_FILE;
    }

    public static String getExtraeOutputDir() {
        return EXTRAE_OUTPUT_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enablePThreads(int n) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if ((numPthreadsEnabled += n) > 0) {
                Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disablePThreads(int n) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if ((numPthreadsEnabled -= n) < 1) {
                numPthreadsEnabled = 0;
                Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerHost(String name, int slots) {
        int id;
        if (DEBUG) {
            LOGGER.debug("Tracing: Registering host " + name + " in the tracing system");
        }
        Map<String, TraceHost> map = hostToSlots;
        synchronized (map) {
            if (hostToSlots.containsKey(name)) {
                if (DEBUG) {
                    LOGGER.debug("Host " + name + " already in tracing system, skipping");
                }
                return -1;
            }
            id = NEXT_HOST_ID.getAndIncrement();
            hostToSlots.put(name, new TraceHost(slots));
        }
        return id;
    }

    public static int getNextSlot(String host) {
        int slot = Tracer.hostToSlots.get(host).getNextSlot();
        if (DEBUG) {
            LOGGER.debug("Tracing: Getting slot " + slot + " of host " + host);
        }
        return slot;
    }

    public static void freeSlot(String host, int slot) {
        if (DEBUG) {
            LOGGER.debug("Tracing: Freeing slot " + slot + " of host " + host);
        }
        Tracer.hostToSlots.get(host).freeSlot(slot);
    }

    public static ArrayList<Integer> getPredecessors(int taskId) {
        return predecessorsMap.get(taskId);
    }

    public static void removePredecessor(int taskId) {
        predecessorsMap.remove(taskId);
    }

    public static void addPredecessors(int taskId, int predecessorTaskId) {
        ArrayList<Integer> predecessors = predecessorsMap.get(taskId);
        if (predecessors == null) {
            predecessors = new ArrayList();
        }
        predecessors.add(predecessorTaskId);
        predecessorsMap.put(taskId, predecessors);
    }

    public static void emitEvent(TraceEvent event) {
        Tracer.emitEvent(event.getType(), (long)event.getId());
    }

    public static final void emitEvent(TraceEventType type, long value) {
        int eventType = type.code;
        Tracer.emitEvent(eventType, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void emitEvent(int eventType, long value) {
        if (DEBUG) {
            LOGGER.debug("Emitting synchronized event [type, id] = [" + eventType + " , " + value + "]");
        }
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Event(eventType, value);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void emitEventAndCounters(TraceEventType type, int value) {
        int eventType = type.code;
        if (DEBUG) {
            LOGGER.debug("Emitting synchronized event with HW counters [type, taskId] = [" + eventType + " , " + value + "]");
        }
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Eventandcounters(eventType, value);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static final void emitEventEnd(TraceEvent event) {
        Tracer.emitEventEnd(event.getType());
    }

    public static final void emitEventEnd(TraceEventType type) {
        int typeCode = type.code;
        Tracer.emitEvent(typeCode, 0L);
    }

    public static final void emitEventEndAndCounters(TraceEventType type) {
        Tracer.emitEventAndCounters(type, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitCommEvent(boolean send, int ownID, int partnerID, int tag, long size) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Comm(send, tag, (int)size, partnerID, ownID);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting communication event [" + (send ? "SEND" : "REC") + "] " + tag + ", " + size + ", " + partnerID + ", " + ownID + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fini(Map<String, Integer> runtimeEvents) {
        if (DEBUG) {
            LOGGER.debug("Tracing: finalizing");
        }
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (enabled) {
                Tracer.defineEvents(runtimeEvents);
                Tracer.stopWrapper();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopWrapper() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            LOGGER.debug("[Tracer] Disabling pthreads");
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            Wrapper.Fini();
            if (DEBUG) {
                LOGGER.debug("[Tracer] Finishing extrae");
            }
            Wrapper.SetOptions(Wrapper.EXTRAE_DISABLE_ALL_OPTIONS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateMasterPackage() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (enabled) {
                String masterPackage = EXTRAE_OUTPUT_DIR + "master" + PACKAGE_SUFFIX;
                Tracer.generatePackage(masterPackage);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void defineEvents(Map<String, Integer> runtimeEvents) {
        if (DEBUG) {
            LOGGER.debug("SignatureToId size: " + runtimeEvents.size());
        }
        block5: for (TraceEventType type : TraceEventType.values()) {
            switch (type) {
                case TASKS_FUNC: {
                    Tracer.defineEventsForFunctions(type, runtimeEvents);
                    continue block5;
                }
                case BINDING_TASKS_FUNC: {
                    continue block5;
                }
                case TASKTYPE: {
                    Tracer.defineEventsForTaskType(type, MethodType.values());
                    continue block5;
                }
                default: {
                    Tracer.defineEventsForType(type);
                }
            }
        }
    }

    private static void defineEventsForTaskType(TraceEventType type, MethodType[] types) {
        int size = types.length + 1;
        long[] values = new long[size];
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (MethodType tp : types) {
            values[i] = (long)tp.ordinal() + 1L;
            descriptionValues[i] = tp.name();
            ++i;
        }
        Wrapper.defineEventType(type.code, type.desc, values, descriptionValues);
    }

    private static void defineEventsForFunctions(TraceEventType type, Map<String, Integer> runtimeEvents) {
        int size = runtimeEvents.entrySet().size() + 1;
        long[] values = new long[size];
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (Map.Entry<String, Integer> entry : runtimeEvents.entrySet()) {
            String signature = entry.getKey();
            Integer methodId = entry.getValue();
            values[i] = (long)methodId.intValue() + 1L;
            LOGGER.debug("Tracing debug: " + signature);
            String methodName = signature.substring(signature.indexOf(46) + 1, signature.length());
            String mN = methodName.replace("(", "([").replace(")", "])");
            if (mN.contains(".")) {
                int start = mN.lastIndexOf(".");
                mN = "[" + mN.substring(0, start) + ".]" + mN.substring(start + 1);
            }
            descriptionValues[i] = mN;
            if (DEBUG) {
                LOGGER.debug("Tracing Funtion Event [i,methodId]: [" + i + "," + methodId + "] => value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(type.code, type.desc, values, descriptionValues);
    }

    private static void defineEventsForType(TraceEventType type) {
        String[] descriptions;
        long[] values;
        boolean endable = type.endable;
        List<TraceEvent> events = type.getEvents();
        int size = events.size();
        int offset = 0;
        if (endable) {
            values = new long[size + 1];
            values[0] = 0L;
            descriptions = new String[size + 1];
            descriptions[0] = "End";
            offset = 1;
        } else {
            values = new long[size];
            descriptions = new String[size];
        }
        for (TraceEvent event : events) {
            values[offset] = event.getId();
            descriptions[offset] = event.getSignature();
            if (DEBUG) {
                LOGGER.debug("Tracing[API]: Type " + type.code + " Event " + offset + "=> value: " + values[offset] + ", Desc: " + descriptions[offset]);
            }
            ++offset;
        }
        Wrapper.defineEventType(type.code, type.desc, values, descriptions);
    }

    public static void generatePackage(String packagePath) {
        if (DEBUG) {
            LOGGER.debug("[Tracer] Generating trace package of " + nodeName);
        }
        try {
            int exitCode = TraceScript.package_extrae(installDir, EXTRAE_OUTPUT_DIR, packagePath, hostId);
            if (exitCode != 0) {
                ErrorManager.warn("Error generating " + nodeName + " package, exit code " + exitCode);
            }
        }
        catch (IOException e) {
            ErrorManager.warn("Error generating " + nodeName + " package", e);
        }
        catch (InterruptedException e) {
            ErrorManager.warn("Error generating " + nodeName + " package (interruptedException)", e);
            Thread.currentThread().interrupt();
        }
    }

    static {
        ENVIRONMENT_VARIABLES = new String[]{"LD_PRELOAD", "EXTRAE_CONFIG_FILE", "EXTRAE_USE_POSIX_CLOCK"};
        NEXT_HOST_ID = new AtomicInteger(1);
        tracerAlreadyLoaded = false;
        enabled = false;
        hostToSlots = new HashMap<String, TraceHost>();
        numPthreadsEnabled = 0;
        predecessorsMap = new HashMap();
        String file = System.getProperty("compss.extrae.file");
        boolean customFile = file != null && !file.isEmpty() && file.compareTo("null") != 0;
        EXTRAE_FILE = customFile ? file : "null";
        String folder = System.getProperty("compss.extrae.working_dir");
        boolean customFolder = folder != null && !folder.isEmpty() && folder.compareTo("null") != 0;
        String string = folder = customFolder ? folder : ".";
        if (!folder.endsWith(File.separator)) {
            folder = folder + File.separator;
        }
        EXTRAE_OUTPUT_DIR = folder;
    }

    private static class TraceHost {
        private boolean[] slots;
        private int numFreeSlots;
        private int nextSlot;

        private TraceHost(int nslots) {
            this.slots = new boolean[nslots];
            this.numFreeSlots = nslots;
            this.nextSlot = 0;
        }

        private int getNextSlot() {
            if (this.numFreeSlots-- > 0) {
                while (this.slots[this.nextSlot]) {
                    this.nextSlot = (this.nextSlot + 1) % this.slots.length;
                }
                this.slots[this.nextSlot] = true;
                return this.nextSlot;
            }
            return -1;
        }

        private void freeSlot(int slot) {
            this.slots[slot] = false;
            this.nextSlot = slot;
            ++this.numFreeSlots;
        }
    }
}

