/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOTaskProfile;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.commands.RetriableCommand;
import es.bsc.compss.worker.COMPSsException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandNIOTaskDone
extends RetriableCommand {
    private boolean successful;
    private NIOTaskResult tr;
    private String jobHistory;
    private COMPSsException compssException;
    private NIOTaskProfile profile;

    public CommandNIOTaskDone() {
        this.compssException = null;
    }

    public CommandNIOTaskDone(NIOTaskResult tr, boolean successful, NIOTaskProfile profile, String jobHistory, COMPSsException e) {
        this.tr = tr;
        this.jobHistory = jobHistory;
        this.successful = successful;
        this.compssException = e;
        this.profile = profile;
    }

    @Override
    public void handle(NIOAgent agent, Connection c) {
        agent.receivedNIOTaskDone(c, this.tr, this.profile, this.successful, this.compssException);
    }

    public COMPSsException getCompssException() {
        return this.compssException;
    }

    public void setCompssException(COMPSsException e) {
        this.compssException = e;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.successful = in.readBoolean();
        this.tr = (NIOTaskResult)in.readObject();
        this.jobHistory = in.readUTF();
        this.compssException = (COMPSsException)in.readObject();
        this.profile = (NIOTaskProfile)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.successful);
        out.writeObject(this.tr);
        out.writeUTF(this.jobHistory);
        out.writeObject(this.compssException);
        out.writeObject(this.profile);
    }

    public String toString() {
        return "Job" + this.tr.getJobId() + " finishes " + (this.successful ? "properly" : "with some errors");
    }

    @Override
    public void error(NIOAgent agent, Connection c) {
        agent.handleTaskDoneCommandError(c, this);
    }

    public NIOTaskResult getTaskResult() {
        return this.tr;
    }

    public String getJobHistory() {
        return this.jobHistory;
    }
}

