/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAclsResponse
extends AbstractResponse {
    public static final Logger log = LoggerFactory.getLogger(DeleteAclsResponse.class);
    private static final String FILTER_RESPONSES_KEY_NAME = "filter_responses";
    private static final String MATCHING_ACLS_KEY_NAME = "matching_acls";
    private static final Schema MATCHING_ACL_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME, CommonFields.PRINCIPAL, CommonFields.HOST, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE);
    private static final Schema MATCHING_ACL_V1 = new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME, CommonFields.RESOURCE_PATTERN_TYPE, CommonFields.PRINCIPAL, CommonFields.HOST, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE);
    private static final Schema DELETE_ACLS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("filter_responses", new ArrayOf(new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("matching_acls", new ArrayOf(MATCHING_ACL_V0), "The matching ACLs")))));
    private static final Schema DELETE_ACLS_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("filter_responses", new ArrayOf(new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("matching_acls", new ArrayOf(MATCHING_ACL_V1), "The matching ACLs")))));
    private final int throttleTimeMs;
    private final List<AclFilterResponse> responses;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_ACLS_RESPONSE_V0, DELETE_ACLS_RESPONSE_V1};
    }

    public DeleteAclsResponse(int throttleTimeMs, List<AclFilterResponse> responses) {
        this.throttleTimeMs = throttleTimeMs;
        this.responses = responses;
    }

    public DeleteAclsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.responses = new ArrayList<AclFilterResponse>();
        for (Object responseStructObj : struct.getArray(FILTER_RESPONSES_KEY_NAME)) {
            Struct responseStruct = (Struct)responseStructObj;
            ApiError error = new ApiError(responseStruct);
            ArrayList<AclDeletionResult> deletions = new ArrayList<AclDeletionResult>();
            for (Object matchingAclStructObj : responseStruct.getArray(MATCHING_ACLS_KEY_NAME)) {
                Struct matchingAclStruct = (Struct)matchingAclStructObj;
                ApiError matchError = new ApiError(matchingAclStruct);
                AccessControlEntry entry = RequestUtils.aceFromStructFields(matchingAclStruct);
                ResourcePattern resource = RequestUtils.resourcePatternromStructFields(matchingAclStruct);
                deletions.add(new AclDeletionResult(matchError, new AclBinding(resource, entry)));
            }
            this.responses.add(new AclFilterResponse(error, deletions));
        }
    }

    @Override
    protected Struct toStruct(short version) {
        this.validate(version);
        Struct struct = new Struct(ApiKeys.DELETE_ACLS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        ArrayList<Struct> responseStructs = new ArrayList<Struct>();
        for (AclFilterResponse response : this.responses) {
            Struct responseStruct = struct.instance(FILTER_RESPONSES_KEY_NAME);
            response.error.write(responseStruct);
            ArrayList<Struct> deletionStructs = new ArrayList<Struct>();
            for (AclDeletionResult deletion : response.deletions()) {
                Struct deletionStruct = responseStruct.instance(MATCHING_ACLS_KEY_NAME);
                deletion.error.write(deletionStruct);
                RequestUtils.resourcePatternSetStructFields(deletion.acl().pattern(), deletionStruct);
                RequestUtils.aceSetStructFields(deletion.acl().entry(), deletionStruct);
                deletionStructs.add(deletionStruct);
            }
            responseStruct.set(MATCHING_ACLS_KEY_NAME, (Object)deletionStructs.toArray(new Struct[0]));
            responseStructs.add(responseStruct);
        }
        struct.set(FILTER_RESPONSES_KEY_NAME, (Object)responseStructs.toArray());
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AclFilterResponse> responses() {
        return this.responses;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (AclFilterResponse response : this.responses) {
            this.updateErrorCounts(errorCounts, response.error.error());
        }
        return errorCounts;
    }

    public static DeleteAclsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteAclsResponse(ApiKeys.DELETE_ACLS.responseSchema(version).read(buffer));
    }

    public String toString() {
        return "(responses=" + Utils.join(this.responses, ",") + ")";
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    private void validate(short version) {
        boolean unsupported;
        if (version == 0 && (unsupported = this.responses.stream().flatMap(r -> ((AclFilterResponse)r).deletions.stream()).map(AclDeletionResult::acl).map(AclBinding::pattern).map(ResourcePattern::patternType).anyMatch(patternType -> patternType != PatternType.LITERAL))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = this.responses.stream().flatMap(r -> ((AclFilterResponse)r).deletions.stream()).map(AclDeletionResult::acl).anyMatch(AclBinding::isUnknown);
        if (unknown) {
            throw new IllegalArgumentException("Response contains UNKNOWN elements");
        }
    }

    public static class AclFilterResponse {
        private final ApiError error;
        private final Collection<AclDeletionResult> deletions;

        public AclFilterResponse(ApiError error, Collection<AclDeletionResult> deletions) {
            this.error = error;
            this.deletions = deletions;
        }

        public AclFilterResponse(Collection<AclDeletionResult> deletions) {
            this(ApiError.NONE, deletions);
        }

        public ApiError error() {
            return this.error;
        }

        public Collection<AclDeletionResult> deletions() {
            return this.deletions;
        }

        public String toString() {
            return "(error=" + this.error + ", deletions=" + Utils.join(this.deletions, ",") + ")";
        }
    }

    public static class AclDeletionResult {
        private final ApiError error;
        private final AclBinding acl;

        public AclDeletionResult(ApiError error, AclBinding acl) {
            this.error = error;
            this.acl = acl;
        }

        public AclDeletionResult(AclBinding acl) {
            this(ApiError.NONE, acl);
        }

        public ApiError error() {
            return this.error;
        }

        public AclBinding acl() {
            return this.acl;
        }

        public String toString() {
            return "(error=" + this.error + ", acl=" + this.acl + ")";
        }
    }
}

