/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Utils;

public class ConsumerGroupDescription {
    private final String groupId;
    private final boolean isSimpleConsumerGroup;
    private final Collection<MemberDescription> members;
    private final String partitionAssignor;
    private final ConsumerGroupState state;
    private final Node coordinator;

    public ConsumerGroupDescription(String groupId, boolean isSimpleConsumerGroup, Collection<MemberDescription> members, String partitionAssignor, ConsumerGroupState state, Node coordinator) {
        this.groupId = groupId == null ? "" : groupId;
        this.isSimpleConsumerGroup = isSimpleConsumerGroup;
        this.members = members == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<MemberDescription>(members));
        this.partitionAssignor = partitionAssignor == null ? "" : partitionAssignor;
        this.state = state;
        this.coordinator = coordinator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerGroupDescription that = (ConsumerGroupDescription)o;
        return this.isSimpleConsumerGroup == that.isSimpleConsumerGroup && this.groupId.equals(that.groupId) && this.members.equals(that.members) && this.partitionAssignor.equals(that.partitionAssignor) && this.state.equals((Object)that.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isSimpleConsumerGroup, this.groupId, this.members, this.partitionAssignor, this.state});
    }

    public String groupId() {
        return this.groupId;
    }

    public boolean isSimpleConsumerGroup() {
        return this.isSimpleConsumerGroup;
    }

    public Collection<MemberDescription> members() {
        return this.members;
    }

    public String partitionAssignor() {
        return this.partitionAssignor;
    }

    public ConsumerGroupState state() {
        return this.state;
    }

    public Node coordinator() {
        return this.coordinator;
    }

    public String toString() {
        return "(groupId=" + this.groupId + ", isSimpleConsumerGroup=" + this.isSimpleConsumerGroup + ", members=" + Utils.join(this.members, ",") + ", partitionAssignor=" + this.partitionAssignor + ", state=" + (Object)((Object)this.state) + ", coordinator=" + this.coordinator + ")";
    }
}

