/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader;

import es.bsc.compss.loader.CustomLoader;
import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.util.ErrorManager;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ITAppLoader {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Loader");

    protected static void load(String chosenLoader, String appName, String[] appArgs) throws Exception {
        try (CustomLoader myLoader = null;){
            myLoader = new CustomLoader(new URL[0]);
            String compssHome = System.getenv("COMPSS_HOME");
            myLoader.addFile(compssHome + LoaderConstants.ENGINE_JAR_WITH_REL_PATH);
            String loaderName = "es.bsc.compss.loader." + chosenLoader + ".ITAppModifier";
            Class<?> modifierClass = myLoader.loadClass(loaderName);
            Object modifier = modifierClass.newInstance();
            LOGGER.debug("Modifying application " + appName + " with loader " + chosenLoader);
            Method method = modifierClass.getMethod("modify", String.class);
            Class modAppClass = (Class)method.invoke(modifier, appName);
            if (modAppClass != null) {
                LOGGER.debug("Application " + appName + " instrumented, executing...");
                Method main = modAppClass.getDeclaredMethod("main", String[].class);
                main.invoke(null, new Object[]{appArgs});
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            ErrorManager.fatal("Error: missing arguments for loader");
        }
        String[] appArgs = new String[args.length - 2];
        System.arraycopy(args, 2, appArgs, 0, appArgs.length);
        try {
            ITAppLoader.load(args[0], args[1], appArgs);
        }
        catch (Exception e) {
            LOGGER.fatal("There was an error when loading or executing your application.", (Throwable)e);
            System.exit(1);
        }
    }
}

