/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.agent.comm.CommAgent;
import es.bsc.compss.agent.comm.CommAgentJob;
import es.bsc.compss.agent.comm.CommAgentWorker;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.nio.master.NIOJob;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.resources.jaxb.ResourcesExternalAdaptorProperties;
import es.bsc.compss.types.resources.jaxb.ResourcesPropertyAdaptorType;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommAgentAdaptor
extends NIOAdaptor
implements CommAgent {
    private static final String PROPERTY_PORT = "PORT";
    public static final CommResource LOCAL_RESOURCE;
    private static final Logger LOGGER;
    private CommAgent ownAgent;

    public CommAgentAdaptor() {
    }

    public CommAgentAdaptor(CommAgent ownAgent) {
        this.ownAgent = ownAgent;
    }

    @Override
    public Configuration constructConfiguration(Map<String, Object> projectProperties, Map<String, Object> resourcesProperties) throws ConstructConfigurationException {
        System.out.println("Constructing configuration");
        ResourcesExternalAdaptorProperties reaProp = (ResourcesExternalAdaptorProperties)resourcesProperties.get("Properties");
        String port = "";
        for (ResourcesPropertyAdaptorType prop : reaProp.getProperty()) {
            String name = prop.getName();
            if (name.compareTo("Port") != 0) continue;
            port = prop.getValue();
        }
        System.out.println("Crating Config with port " + port);
        MethodConfiguration mc = new MethodConfiguration(CommAgentAdaptor.class.getCanonicalName());
        mc.addProperty(PROPERTY_PORT, port);
        return mc;
    }

    @Override
    public COMPSsWorker initWorker(Configuration config, NodeMonitor monitor) {
        System.out.println("Initializing Worker ");
        MethodConfiguration aConf = (MethodConfiguration)config;
        String name = aConf.getHost();
        int port = Integer.parseInt(aConf.getProperty(PROPERTY_PORT));
        return new CommAgentWorker(name, port, this, monitor);
    }

    @Override
    public void receivedNewTask(NIONode master, NIOTask t, List<String> obsoleteData) {
        for (String obsolete : obsoleteData) {
            Comm.removeData((String)obsolete, (boolean)true);
        }
        this.receivedNewTask(master, (CommTask)t);
    }

    @Override
    public void receivedNewTask(NIONode master, CommTask request) {
        this.ownAgent.receivedNewTask(master, request);
    }

    @Override
    public void print(Object o) {
        this.ownAgent.print(o);
    }

    @Override
    public void addResources(es.bsc.compss.agent.types.Resource<?, ?> res) {
        this.ownAgent.addResources(res);
    }

    @Override
    public void removeResources(es.bsc.compss.agent.types.Resource<?, ?> node) {
        this.ownAgent.removeResources(node);
    }

    @Override
    public void removeNode(String node) {
        this.ownAgent.removeNode(node);
    }

    @Override
    public void receivedRemoveObsoletes(NIONode node, List<String> obsolete) {
        for (String obsoleteData : obsolete) {
            Comm.removeData((String)obsoleteData, (boolean)true);
        }
    }

    @Override
    public void lostNode(String node) {
        this.ownAgent.lostNode(node);
    }

    @Override
    public boolean isMyUuid(String uuid, String nodeName) {
        return true;
    }

    @Override
    protected void retrieveAdditionalJobFiles(Connection connection, boolean success, int jobId, int taskId, JobHistory history) {
    }

    @Override
    protected void updateCopiedData(LogicalData tgtData, DataLocation actualLocation) {
    }

    @Override
    protected void finishJob(NIOJob nj, boolean successful, NIOTaskResult ntr, Exception e) {
        CommAgentJob commJob = (CommAgentJob)nj;
        commJob.taskFinished(successful, ntr, e, this.ownAgent);
    }

    @Override
    public Resource getNodeFromResource(es.bsc.compss.agent.types.Resource<?, ?> r) {
        return null;
    }

    static {
        LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
        String localAgentName = COMPSsNode.getMasterName();
        String portStr = System.getProperty("compss.masterPort");
        int port = Integer.parseInt(portStr);
        if (localAgentName != null && localAgentName.isEmpty()) {
            localAgentName = null;
        }
        LOCAL_RESOURCE = new CommResource(localAgentName, port);
    }
}

