/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm.messages.types;

import es.bsc.compss.agent.types.ApplicationResult;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.nio.NIOResult;
import es.bsc.compss.nio.NIOUri;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class CommResult
extends NIOResult
implements ApplicationResult {
    private Collection<RemoteDataLocation> sources = new LinkedList<RemoteDataLocation>();

    public CommResult() {
    }

    public CommResult(NIOUri uri) {
        super(uri);
    }

    public void setRemoteData(Collection<RemoteDataLocation> sources) {
        this.sources = sources;
    }

    public Collection<RemoteDataLocation> getLocations() {
        return this.sources;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sources);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sources = (Collection)in.readObject();
    }

    @Override
    protected void dumpContent(StringBuilder sb) {
        Iterator<RemoteDataLocation> itr;
        sb.append("\"remote_data\":[");
        if (this.sources != null && (itr = this.sources.iterator()).hasNext()) {
            RemoteDataLocation loc = itr.next();
            sb.append(loc);
            while (itr.hasNext()) {
                loc = itr.next();
                sb.append("," + loc);
            }
        }
        sb.append("],");
        super.dumpContent(sb);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.dumpContent(sb);
        sb.append("}");
        return sb.toString();
    }
}

