/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.nio.NIONode;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.CommAgentJob;
import es.bsc.compss.agent.comm.CommAgentURI;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import java.util.List;
import java.util.Set;

public class CommAgentWorker
extends NIOWorkerNode {
    private final CommResource remoteResource;

    public CommAgentWorker(String name, int port, CommAgentAdaptor adaptor, NodeMonitor monitor) {
        super(null, adaptor, monitor);
        this.remoteResource = new CommResource(name, port);
        this.node = new NIONode(name, port);
        this.started = true;
    }

    @Override
    public String getHost() {
        return this.remoteResource.getName();
    }

    @Override
    public String getUser() {
        return "";
    }

    @Override
    public String getClasspath() {
        return "";
    }

    @Override
    public String getPythonpath() {
        return "";
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
    }

    @Override
    public void announceDestruction() {
    }

    @Override
    public void announceCreation() {
    }

    @Override
    public String getName() {
        return this.remoteResource.getName();
    }

    @Override
    public void start() throws InitNodeException {
    }

    @Override
    public void setInternalURI(MultiURI u) throws UnstartedNodeException {
        CommAgentURI nu = new CommAgentURI(this.remoteResource, this.node, u.getPath(), ProtocolType.ANY_URI);
        u.setInternalURI(CommAgentAdaptor.ID, (Object)nu);
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        return new CommAgentJob(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener, predecessors, numSuccessors);
    }

    @Override
    public void stop(ShutdownListener sl) {
        sl.notifyEnd();
    }

    @Override
    public SimpleURI getCompletePath(DataType type, String name) {
        SimpleURI uri = new SimpleURI(name);
        return uri;
    }

    @Override
    public void deleteTemporary() {
    }

    @Override
    public Set<String> generateWorkerAnalysisFiles() {
        return null;
    }

    @Override
    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
        sl.notifyEnd();
    }

    @Override
    public Set<String> generateWorkerDebugFiles() {
        return null;
    }

    @Override
    public void increaseComputingCapabilities(ResourceDescription description) {
    }

    @Override
    public void reduceComputingCapabilities(ResourceDescription description) {
    }

    @Override
    public String getAdaptor() {
        return this.remoteResource.getAdaptor();
    }

    @Override
    public Object getProjectProperties() {
        return this.remoteResource.getProjectConf();
    }

    @Override
    public Object getResourcesProperties() {
        return this.remoteResource.getResourceConf();
    }

    public String toString() {
        return "CommAgentWorker=[remoteResource=" + this.remoteResource.toString() + "; node" + this.node.toString() + "]";
    }
}

