/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master.configuration;

import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import java.util.Arrays;
import java.util.List;

public class NIOConfiguration
extends MethodConfiguration {
    public static final String SSH_REMOTE_EXECUTION_COMMAND = "ssh";
    public static final String SRUN_REMOTE_EXECUTION_COMMAND = "srun";
    public static final String BLAUNCH_REMOTE_EXECUTION_COMMAND = "blaunch";
    public static final String QRSH_REMOTE_EXECUTION_COMMAND = "qrsh";
    public static final String NO_REMOTE_EXECUTION_COMMAND = "none";
    private static final List<String> AVAILABLE_REMOTE_EXECUTION_COMMANDS = Arrays.asList("ssh", "srun", "blaunch", "qrsh", "none");
    public static final String DEFAULT_REMOTE_EXECUTION_COMMAND = "ssh";
    private String remoteExecutionCommand;

    public NIOConfiguration(String adaptorName) {
        super(adaptorName);
    }

    public NIOConfiguration(NIOConfiguration clone) {
        super(clone);
        this.remoteExecutionCommand = clone.remoteExecutionCommand;
    }

    @Override
    public MethodConfiguration copy() {
        return new NIOConfiguration(this);
    }

    public String[] getRemoteExecutionCommand(String user, String resource, String[] command) {
        String[] cmd = null;
        switch (this.remoteExecutionCommand) {
            case "none": {
                break;
            }
            case "qrsh": {
                cmd = new String[3 + command.length];
                cmd[0] = QRSH_REMOTE_EXECUTION_COMMAND;
                cmd[1] = "-inherit";
                cmd[2] = resource;
                System.arraycopy(command, 0, cmd, 3, command.length);
                break;
            }
            case "blaunch": {
                cmd = new String[2 + command.length];
                cmd[0] = BLAUNCH_REMOTE_EXECUTION_COMMAND;
                cmd[1] = resource;
                System.arraycopy(command, 0, cmd, 2, command.length);
                break;
            }
            case "srun": {
                cmd = new String[4 + command.length];
                cmd[0] = SRUN_REMOTE_EXECUTION_COMMAND;
                cmd[1] = "-n1";
                cmd[2] = "-N1";
                cmd[3] = "--nodelist=" + resource;
                System.arraycopy(command, 0, cmd, 4, command.length);
                break;
            }
            default: {
                cmd = new String[6 + command.length];
                cmd[0] = "ssh";
                cmd[1] = "-o StrictHostKeyChecking=no";
                cmd[2] = "-o BatchMode=yes";
                cmd[3] = "-o ChallengeResponseAuthentication=no";
                cmd[4] = "-p " + this.getSpawnerPort();
                cmd[5] = (user == null || user.isEmpty() ? "" : user + "@") + resource;
                System.arraycopy(command, 0, cmd, 6, command.length);
            }
        }
        return cmd;
    }

    public void setRemoteExecutionCommand(String remoteExecutionCommand) {
        this.remoteExecutionCommand = remoteExecutionCommand;
    }

    public static List<String> getAvailableRemoteExecutionCommands() {
        return AVAILABLE_REMOTE_EXECUTION_COMMANDS;
    }
}

