/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.CommAgentURI;
import es.bsc.compss.agent.comm.messages.types.CommParam;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.agent.types.RemoteDataInformation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.nio.master.NIOJob;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.MultiNodeImplementation;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import java.util.LinkedList;
import java.util.List;

class CommAgentJob
extends NIOJob {
    public CommAgentJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        super(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener);
    }

    @Override
    public CommTask prepareJob() {
        System.out.println("Preparing Job");
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        switch (absMethodImpl.getMethodType()) {
            case METHOD: {
                MethodImplementation methodImpl = (MethodImplementation)absMethodImpl;
                String methodName = methodImpl.getAlternativeMethodName();
                if (methodName != null && !methodName.isEmpty()) break;
                methodImpl.setAlternativeMethodName(this.taskParams.getName());
                break;
            }
            case MULTI_NODE: {
                MultiNodeImplementation multiNodeImpl = (MultiNodeImplementation)absMethodImpl;
                String multiNodeMethodName = multiNodeImpl.getMethodName();
                if (multiNodeMethodName != null && !multiNodeMethodName.isEmpty()) break;
                multiNodeImpl.setMethodName(this.taskParams.getName());
                break;
            }
        }
        LinkedList<NIOParam> params = this.addParams();
        int numParams = params.size() - this.taskParams.getNumReturns();
        CommTask nt = new CommTask(this.getLang(), DEBUG, absMethodImpl, null, this.taskParams.hasTargetObject(), this.taskParams.getNumReturns(), params, numParams, absMethodImpl.getRequirements(), this.slaveWorkersNodeNames, this.taskId, this.impl.getTaskType(), this.jobId, this.history, this.transferId, this.getOnFailure(), this.getTimeOut(), CommAgentAdaptor.LOCAL_RESOURCE);
        return nt;
    }

    private LinkedList<NIOParam> addParams() {
        LinkedList<NIOParam> params = new LinkedList<NIOParam>();
        for (Parameter param : this.taskParams.getParameters()) {
            CommParam commParam;
            switch (param.getType()) {
                case FILE_T: 
                case OBJECT_T: 
                case PSCO_T: 
                case STREAM_T: 
                case EXTERNAL_STREAM_T: 
                case EXTERNAL_PSCO_T: 
                case BINDING_OBJECT_T: {
                    commParam = this.buildCommParamFromDependencyParameter((DependencyParameter)param);
                    break;
                }
                case COLLECTION_T: {
                    throw new UnsupportedOperationException();
                }
                default: {
                    commParam = this.buildCommParamFromBasicParameter((BasicTypeParameter)param);
                }
            }
            System.out.println("\t " + commParam);
            params.add(commParam);
        }
        return params;
    }

    private CommParam buildCommParamFromBasicParameter(BasicTypeParameter param) {
        DataType type = param.getType();
        Direction dir = param.getDirection();
        StdIOStream stdIOStream = param.getStream();
        String prefix = param.getPrefix();
        String name = param.getName();
        String pyType = param.getContentType();
        CommParam commParam = new CommParam(null, type, dir, stdIOStream, prefix, name, pyType, null);
        commParam.setValue(param.getValue());
        return commParam;
    }

    private CommParam buildCommParamFromDependencyParameter(DependencyParameter dPar) {
        String dataMgmtId;
        String renaming = null;
        DataAccessId dAccId = dPar.getDataAccessId();
        if (dAccId instanceof RWAccessId) {
            RWAccessId rwaId = (RWAccessId)dAccId;
            renaming = rwaId.getReadDataInstance().getRenaming();
            dataMgmtId = rwaId.getWrittenDataInstance().getRenaming();
        } else if (dAccId instanceof RAccessId) {
            RAccessId raId = (RAccessId)dAccId;
            dataMgmtId = renaming = raId.getReadDataInstance().getRenaming();
        } else {
            WAccessId waId = (WAccessId)dAccId;
            dataMgmtId = waId.getWrittenDataInstance().getRenaming();
        }
        LogicalData sourceDataLD = null;
        String pscoId = null;
        if (renaming != null) {
            sourceDataLD = Comm.getData(renaming);
            pscoId = sourceDataLD.getPscoId();
        }
        if (pscoId != null) {
            if (dPar.getType().equals((Object)DataType.OBJECT_T)) {
                dPar.setType(DataType.PSCO_T);
            } else if (dPar.getType().equals((Object)DataType.FILE_T)) {
                dPar.setType(DataType.EXTERNAL_PSCO_T);
            }
        }
        DataType type = dPar.getType();
        Direction dir = dPar.getDirection();
        StdIOStream stdIOStream = dPar.getStream();
        String prefix = dPar.getPrefix();
        String name = dPar.getName();
        String pyType = dPar.getContentType();
        CommParam commParam = new CommParam(dataMgmtId, type, dir, stdIOStream, prefix, name, pyType, dPar.getOriginalName());
        NIOData sourceData = (NIOData)dPar.getDataSource();
        if (sourceData != null) {
            RemoteDataInformation remoteData = new RemoteDataInformation(renaming);
            for (NIOUri uri : sourceData.getSources()) {
                CommAgentURI caURI;
                if (uri instanceof CommAgentURI) {
                    caURI = (CommAgentURI)uri;
                    remoteData.addSource(new RemoteDataLocation(caURI.getAgent(), uri.getPath()));
                    continue;
                }
                caURI = new CommAgentURI(uri);
                remoteData.addSource(new RemoteDataLocation(caURI.getAgent(), uri.getPath()));
            }
            commParam.setRemoteData(remoteData);
        }
        return commParam;
    }
}

