/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.invokers.util.StdIOStream;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.BinaryImplementation;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class BinaryInvoker
extends Invoker {
    private static final int NUM_BASE_BINARY_ARGS = 1;
    private final String binary;

    public BinaryInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        BinaryImplementation binaryImpl = null;
        try {
            binaryImpl = (BinaryImplementation)invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)invocation.getMethodImplementation().getMethodType()), e);
        }
        this.binary = binaryImpl.getBinary();
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        LOGGER.info("Invoked " + this.binary + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            LOGGER.error("Exception running binary", (Throwable)iee);
            throw new JobExecutionException(iee);
        }
        try {
            BinaryRunner.closeStreams(this.invocation.getParams(), this.pythonInterpreter);
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException(se);
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            if (invocationParam.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(invocationParam, retValue);
                continue;
            }
            invocationParam.setValue(retValue);
            invocationParam.setValueClass(retValue.getClass());
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, this.pythonInterpreter);
        String[] cmd = new String[1 + binaryParams.size()];
        cmd[0] = this.binary;
        for (int i = 0; i < binaryParams.size(); ++i) {
            cmd[1 + i] = binaryParams.get(i);
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[BINARY INVOKER] Begin binary call to " + this.binary);
            outLog.println("[BINARY INVOKER] On WorkingDir : " + this.taskSandboxWorkingDir.getAbsolutePath());
            outLog.print("[BINARY INVOKER] BINARY CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
            outLog.println("[BINARY INVOKER] Binary STDIN: " + streamValues.getStdIn());
            outLog.println("[BINARY INVOKER] Binary STDOUT: " + streamValues.getStdOut());
            outLog.println("[BINARY INVOKER] Binary STDERR: " + streamValues.getStdErr());
        }
        return BinaryRunner.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream());
    }

    @Override
    public void cancelMethod() {
    }
}

