/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.types.annotations.parameter.DataType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import storage.StubItf;

public class NIOTaskResult
implements Externalizable {
    private int jobId;
    private List<DataType> paramTypes = new LinkedList<DataType>();
    private List<Object> paramValues = new LinkedList<Object>();

    public NIOTaskResult() {
    }

    public NIOTaskResult(int jobId, List<NIOParam> arguments, NIOParam target, List<NIOParam> results) {
        this.jobId = jobId;
        block12: for (NIOParam np : arguments) {
            this.paramTypes.add(np.getType());
            if (np.isWriteFinalValue()) {
                switch (np.getType()) {
                    case PSCO_T: {
                        this.paramValues.add(((StubItf)np.getValue()).getID());
                        continue block12;
                    }
                    case EXTERNAL_PSCO_T: {
                        this.paramValues.add(np.getValue());
                        continue block12;
                    }
                }
                this.paramValues.add(null);
                continue;
            }
            this.paramValues.add(null);
        }
        if (target != null) {
            this.paramTypes.add(target.getType());
            if (target.isWriteFinalValue()) {
                switch (target.getType()) {
                    case PSCO_T: {
                        this.paramValues.add(((StubItf)target.getValue()).getID());
                        break;
                    }
                    case EXTERNAL_PSCO_T: {
                        this.paramValues.add(target.getValue());
                        break;
                    }
                    default: {
                        this.paramValues.add(null);
                        break;
                    }
                }
            } else {
                this.paramValues.add(null);
            }
        }
        block13: for (NIOParam np : results) {
            this.paramTypes.add(np.getType());
            switch (np.getType()) {
                case PSCO_T: {
                    this.paramValues.add(((StubItf)np.getValue()).getID());
                    continue block13;
                }
                case EXTERNAL_PSCO_T: {
                    this.paramValues.add(np.getValue());
                    continue block13;
                }
            }
            this.paramValues.add(null);
        }
    }

    public int getJobId() {
        return this.jobId;
    }

    public List<DataType> getParamTypes() {
        return this.paramTypes;
    }

    public Object getParamValue(int i) {
        return this.paramValues.get(i);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = in.readInt();
        this.paramTypes = (LinkedList)in.readObject();
        this.paramValues = (LinkedList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.jobId);
        out.writeObject(this.paramTypes);
        out.writeObject(this.paramValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[JOB_RESULT ");
        sb.append("[JOB ID= ").append(this.jobId).append("]");
        sb.append("[PARAM_TYPES");
        for (DataType dataType : this.paramTypes) {
            sb.append(" ").append((Object)dataType);
        }
        sb.append("]");
        sb.append("[PARAM_VALUES");
        for (Object object : this.paramValues) {
            sb.append(" ").append(object);
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

