/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CommutativeIdentifier;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.data.DataAccessId;
import java.util.LinkedList;
import java.util.List;

public class CommutativeGroupTask
extends AbstractTask {
    private final CommutativeIdentifier comId;
    private final List<Task> commutativeTasks = new LinkedList<Task>();
    private AbstractTask parentDataDependency;
    private int executionCount = 0;
    private int finalVersion = 0;
    private LinkedList<DataAccessId> versions = new LinkedList();
    private DataAccessId registeredVersion = null;
    private boolean currentlyExecuting = false;
    private int taskExecuting;
    private boolean graphDrawn;

    public CommutativeGroupTask(Long appId, CommutativeIdentifier comId) {
        super(appId);
        this.comId = comId;
        this.graphDrawn = false;
        this.taskExecuting = 0;
    }

    public List<Task> getCommutativeTasks() {
        return this.commutativeTasks;
    }

    public CommutativeIdentifier getCommutativeIdentifier() {
        return this.comId;
    }

    public void addCommutativeTask(Task task) {
        this.commutativeTasks.add(task);
    }

    public void setFinalVersion(int version) {
        this.finalVersion = version;
    }

    public void removePredecessor(Task t) {
        super.getPredecessors().remove(t);
    }

    public void taskBeingExecuted(int taskId) {
        this.currentlyExecuting = true;
        this.taskExecuting = taskId;
    }

    public void taskEndedExecution() {
        this.currentlyExecuting = false;
        this.taskExecuting = 0;
    }

    public void addVersionToList(DataAccessId daId) {
        this.versions.add(daId);
    }

    public DataAccessId getRegisteredVersion() {
        if (this.registeredVersion == null) {
            this.registeredVersion = this.versions.get(0);
        }
        return this.registeredVersion;
    }

    public void setRegisteredVersion(DataAccessId daId) {
        this.registeredVersion = daId;
    }

    public void nextVersion() {
        if (!this.versions.isEmpty()) {
            this.registeredVersion = this.versions.getFirst();
            this.versions.remove(this.registeredVersion);
            for (Task t : this.commutativeTasks) {
                t.setVersion(this.registeredVersion);
            }
        }
    }

    public void setGraphDrawn() {
        this.graphDrawn = true;
    }

    public boolean getGraphDrawn() {
        return this.graphDrawn;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public void increaseExecutionCount() {
        ++this.executionCount;
    }

    public AbstractTask getParentDataDependency() {
        return this.parentDataDependency;
    }

    public void setParentDataDependency(AbstractTask t) {
        this.parentDataDependency = t;
    }

    public boolean processingExecution(int taskId) {
        if (this.currentlyExecuting && taskId == this.taskExecuting) {
            return false;
        }
        return this.currentlyExecuting;
    }

    public int getFinalVersion() {
        return this.finalVersion;
    }

    @Override
    public String getDotDescription() {
        return null;
    }

    @Override
    public String getLegendDescription() {
        return null;
    }

    @Override
    public String getColor() {
        return null;
    }
}

