/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.nio.NIONode;
import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.Agent;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.comm.CommAgent;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.CommAgentConfig;
import es.bsc.compss.agent.comm.PrintMonitor;
import es.bsc.compss.agent.comm.TaskMonitor;
import es.bsc.compss.agent.comm.messages.types.CommParam;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class CommAgentImpl
implements AgentInterface<CommAgentConfig>,
CommAgent {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Agent");
    private CommAgentAdaptor adaptor = null;

    @Override
    public CommAgentConfig configure(JSONObject confJSON) throws AgentException {
        CommAgentConfig conf;
        try {
            String portSTR = confJSON.getString("PORT");
            portSTR = EnvironmentLoader.loadFromEnvironment(portSTR);
            int port = Integer.valueOf(portSTR);
            if (port <= 0) {
                throw new AgentException("Invalid port number for Comm agent's interface.");
            }
            conf = new CommAgentConfig(this, port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AgentException(e);
        }
        return conf;
    }

    @Override
    public void start(CommAgentConfig conf) throws AgentException {
        int port = conf.getPort();
        System.setProperty("compss.masterPort", Integer.toString(port));
        CommAgentAdaptor nioAdaptor = (CommAgentAdaptor)Comm.getAdaptors().get(CommAgentAdaptor.ID);
        CommAgentAdaptor commAgentAdaptor = (CommAgentAdaptor)Comm.getAdaptors().get(CommAgentAdaptor.class.getCanonicalName());
        if (nioAdaptor == null && commAgentAdaptor == null) {
            this.adaptor = new CommAgentAdaptor(this);
            LOGGER.info("Starting CommAgent on port " + port);
            this.adaptor.init();
            Comm.registerAdaptor(CommAgentAdaptor.ID, this.adaptor);
            Comm.registerAdaptor(CommAgentAdaptor.class.getCanonicalName(), this.adaptor);
        } else if (nioAdaptor == null) {
            this.adaptor = commAgentAdaptor;
            Comm.registerAdaptor(CommAgentAdaptor.class.getCanonicalName(), this.adaptor);
        } else {
            this.adaptor = nioAdaptor;
            Comm.registerAdaptor(CommAgentAdaptor.ID, this.adaptor);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void print(Object o) {
        System.out.println(o);
    }

    @Override
    public void addResources(Resource<?, ?> res) {
        try {
            Agent.addResources(res);
        }
        catch (AgentException ex) {
            ErrorManager.warn("Could not add the new server", ex);
        }
    }

    @Override
    public void removeResources(Resource<?, ?> resource) {
        try {
            Agent.removeResources(resource.getName(), resource.getDescription());
        }
        catch (AgentException ae) {
            ae.printStackTrace();
        }
    }

    @Override
    public void removeNode(String node) {
        try {
            Agent.removeNode(node);
        }
        catch (AgentException ae) {
            ae.printStackTrace();
        }
    }

    @Override
    public void lostNode(String node) {
        try {
            Agent.lostNode(node);
        }
        catch (AgentException ae) {
            ae.printStackTrace();
        }
    }

    @Override
    public void receivedNewTask(NIONode master, CommTask request) {
        COMPSsConstants.Lang lang = request.getLang();
        MethodImplementation impl = (MethodImplementation)request.getMethodImplementation();
        String className = impl.getDeclaringClass();
        String methodName = impl.getAlternativeMethodName();
        int argsCount = request.getParams().size();
        int resultsCount = request.getResults().size();
        ApplicationParameter[] arguments = new ApplicationParameter[argsCount];
        int paramId = 0;
        for (NIOParam np : request.getParams()) {
            arguments[paramId] = (CommParam)np;
            ++paramId;
        }
        CommParam target = (CommParam)request.getTarget();
        ApplicationParameter[] results = new ApplicationParameter[resultsCount];
        paramId = 0;
        for (NIOParam np : request.getResults()) {
            results[paramId] = (CommParam)np;
            ++paramId;
        }
        String cei = request.getCei();
        MethodResourceDescription requirements = request.getRequirements();
        CommResource orchestrator = request.getOrchestrator();
        System.out.println("S'ha de notificat la peticio a " + orchestrator);
        PrintMonitor monitor = orchestrator == null ? new PrintMonitor() : new TaskMonitor(orchestrator, request);
        if (cei != null) {
            this.startMain(lang, className, methodName, arguments, target, results, cei, requirements, monitor);
        } else {
            this.startTask(lang, className, methodName, arguments, target, results, requirements, monitor);
        }
    }

    private void startMain(COMPSsConstants.Lang lang, String className, String methodName, ApplicationParameter[] params, ApplicationParameter target, ApplicationParameter[] results, String ceiName, MethodResourceDescription requirements, AppMonitor monitor) {
        System.out.println("Es vol executar el main " + (Object)((Object)lang) + " " + className + "." + methodName + " parallelitzat amb " + ceiName);
        System.out.println("Parameters: ");
        for (ApplicationParameter param : params) {
            System.out.println("\t* " + param);
        }
        System.out.println("La tasca reservar\u00e0 " + requirements);
        try {
            Agent.runMain(lang, ceiName, className, methodName, params, target, results, monitor);
        }
        catch (AgentException ex) {
            ex.printStackTrace();
        }
    }

    private void startTask(COMPSsConstants.Lang lang, String className, String methodName, ApplicationParameter[] params, ApplicationParameter target, ApplicationParameter[] results, MethodResourceDescription requirements, AppMonitor monitor) {
        try {
            Agent.runTask(lang, className, methodName, params, target, results, requirements, monitor);
        }
        catch (AgentException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        CommAgentImpl cai = new CommAgentImpl();
        CommAgentConfig config = new CommAgentConfig(cai, port);
        Agent.startInterface(config);
    }
}

