/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.PrintMonitor;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.uri.SimpleURI;
import java.util.LinkedList;

class TaskMonitor
extends PrintMonitor {
    private static final TransferManager TM = CommAgentAdaptor.getTransferManager();
    private final CommResource orchestrator;
    private final CommTask task;
    private final DataType[] paramTypes;
    private final String[] paramLocations;
    private boolean successful;

    public TaskMonitor(CommResource orchestrator, CommTask request) {
        this.orchestrator = orchestrator;
        this.successful = false;
        this.task = request;
        int argsCount = request.getParams().size();
        int resultsCount = request.getResults().size();
        int numParams = argsCount + resultsCount + (request.getTarget() != null ? 1 : 0);
        this.paramTypes = new DataType[numParams];
        this.paramLocations = new String[numParams];
    }

    @Override
    public void valueGenerated(int paramId, String paramName, DataType paramType, String dataId, Object dataLocation) {
        super.valueGenerated(paramId, paramName, paramType, dataId, dataLocation);
        this.paramTypes[paramId] = paramType;
        if (paramType == DataType.OBJECT_T) {
            LogicalData ld = Comm.getData(dataId);
            if (ld.getPscoId() != null) {
                this.paramTypes[paramId] = DataType.PSCO_T;
                SimpleURI targetURI = new SimpleURI(ProtocolType.PERSISTENT_URI.getSchema() + ld.getPscoId());
                this.paramLocations[paramId] = targetURI.toString();
            } else {
                this.paramTypes[paramId] = paramType;
                this.paramLocations[paramId] = dataLocation.toString();
            }
        } else {
            this.paramTypes[paramId] = paramType;
            this.paramLocations[paramId] = dataLocation.toString();
        }
        NIOParam originalParam = this.obtainJobParameter(paramId);
        String originalDataMgmtId = originalParam.getDataMgmtId();
        if (dataId.compareTo(originalDataMgmtId) != 0) {
            Comm.linkData(originalDataMgmtId, dataId);
        }
    }

    private NIOParam obtainJobParameter(int paramId) {
        int paramsCount = this.task.getParams().size();
        if (paramId < paramsCount) {
            return this.task.getParams().get(paramId);
        }
        paramId -= paramsCount;
        if (this.task.getTarget() != null) {
            if (paramId == 0) {
                return this.task.getTarget();
            }
            --paramId;
        }
        return this.task.getResults().get(paramId);
    }

    @Override
    public void onSuccesfulExecution() {
        super.onSuccesfulExecution();
        this.successful = true;
    }

    @Override
    public void onCompletion() {
        super.onCompletion();
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    @Override
    public void onFailure() {
        super.onFailure();
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    public void notifyEnd() {
        NIONode n = new NIONode(this.orchestrator.getName(), this.orchestrator.getPort());
        CommandNIOTaskDone cmd = null;
        int jobId = this.task.getJobId();
        NIOTaskResult tr = new NIOTaskResult(jobId, new LinkedList<NIOParam>(), null, new LinkedList<NIOParam>());
        Connection c = TM.startConnection(n);
        cmd = new CommandNIOTaskDone(tr, this.successful, this.task.getHistory().toString(), null);
        c.sendCommand(cmd);
        c.finishConnection();
    }
}

