/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.api.impl;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.components.monitor.impl.RuntimeMonitor;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.total.ObjectRegistry;
import es.bsc.compss.loader.total.StreamRegistry;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.DoNothingTaskMonitor;
import es.bsc.compss.types.FatalErrorHandler;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.FileAccessParams;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.BindingObjectParameter;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.ExternalStreamParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.parameter.StreamParameter;
import es.bsc.compss.types.resources.MasterResourceImpl;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourcesPool;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.RuntimeConfigManager;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class COMPSsRuntimeImpl
implements COMPSsRuntime,
LoaderAPI,
FatalErrorHandler {
    private static final String WARN_IT_FILE_NOT_READ = "WARNING: COMPSs Properties file could not be read";
    private static final String WARN_FILE_EMPTY_DEFAULT = "WARNING: COMPSs Properties file is null. Setting default values";
    private static final String WARN_VERSION_PROPERTIES = "WARNING: COMPSs Runtime VERSION-BUILD properties file could not be read";
    private static final String ERROR_FILE_NAME = "ERROR: Cannot parse file name";
    private static final String ERROR_BINDING_OBJECT_PARAMS = "ERROR: Incorrect number of parameters for external objects";
    private static final String WARN_WRONG_DIRECTION = "WARNING: Invalid parameter direction: ";
    private static String COMPSs_VERSION = null;
    private static String COMPSs_BUILDNUMBER = null;
    private static boolean initialized = false;
    private static final int NUM_FIELDS_PER_PARAM = 6;
    protected static final String DEFAULT_LANG_STR = System.getProperty("compss.lang");
    protected static final COMPSsConstants.Lang DEFAULT_LANG = DEFAULT_LANG_STR == null ? COMPSsConstants.Lang.JAVA : COMPSsConstants.Lang.valueOf(DEFAULT_LANG_STR.toUpperCase());
    private static ObjectRegistry oReg;
    private static StreamRegistry sReg;
    private static AccessProcessor ap;
    private static TaskDispatcher td;
    private static GraphGenerator graphMonitor;
    private static RuntimeMonitor runtimeMonitor;
    private static final Logger LOGGER;
    private static final TaskMonitor DO_NOTHING_MONITOR;

    private static void setPropertiesFromRuntime(RuntimeConfigManager manager) {
        try {
            if (manager != null) {
                if (manager.getDeploymentId() != null && System.getProperty("compss.uuid") == null) {
                    System.setProperty("compss.uuid", manager.getDeploymentId());
                }
                if (manager.getMasterName() != null && System.getProperty("compss.masterName") == null) {
                    System.setProperty("compss.masterName", manager.getMasterName());
                }
                if (manager.getMasterPort() != null && System.getProperty("compss.masterPort") == null) {
                    System.setProperty("compss.masterPort", manager.getMasterPort());
                }
                if (manager.getAppName() != null && System.getProperty("compss.appName") == null) {
                    System.setProperty("compss.appName", manager.getAppName());
                }
                if (manager.getTaskSummary() != null && System.getProperty("compss.summary") == null) {
                    System.setProperty("compss.summary", manager.getTaskSummary());
                }
                if (manager.getCOMPSsBaseLogDir() != null && System.getProperty("compss.baseLogDir") == null) {
                    System.setProperty("compss.baseLogDir", manager.getCOMPSsBaseLogDir());
                }
                if (manager.getSpecificLogDir() != null && System.getProperty("compss.specificLogDir") == null) {
                    System.setProperty("compss.specificLogDir", manager.getSpecificLogDir());
                }
                if (manager.getLog4jConfiguration() != null && System.getProperty("log4j.configurationFile") == null) {
                    System.setProperty("log4j.configurationFile", manager.getLog4jConfiguration());
                }
                if (manager.getResourcesFile() != null && System.getProperty("compss.resources.file") == null) {
                    System.setProperty("compss.resources.file", manager.getResourcesFile());
                }
                if (manager.getResourcesSchema() != null && System.getProperty("compss.resources.schema") == null) {
                    System.setProperty("compss.resources.schema", manager.getResourcesSchema());
                }
                if (manager.getProjectFile() != null && System.getProperty("compss.project.file") == null) {
                    System.setProperty("compss.project.file", manager.getProjectFile());
                }
                if (manager.getProjectSchema() != null && System.getProperty("compss.project.schema") == null) {
                    System.setProperty("compss.project.schema", manager.getProjectSchema());
                }
                if (manager.getScheduler() != null && System.getProperty("compss.scheduler") == null) {
                    System.setProperty("compss.scheduler", manager.getScheduler());
                }
                if (manager.getMonitorInterval() > 0L && System.getProperty("compss.monitor") == null) {
                    System.setProperty("compss.monitor", Long.toString(manager.getMonitorInterval()));
                }
                if (manager.getGATAdaptor() != null && System.getProperty("gat.adaptor.path") == null) {
                    System.setProperty("gat.adaptor.path", manager.getGATAdaptor());
                }
                if (manager.getGATBrokerAdaptor() != null && System.getProperty("gat.broker.adaptor") == null) {
                    System.setProperty("gat.broker.adaptor", manager.getGATBrokerAdaptor());
                }
                if (manager.getGATFileAdaptor() != null && System.getProperty("gat.file.adaptor") == null) {
                    System.setProperty("gat.file.adaptor", manager.getGATFileAdaptor());
                }
                if (manager.getWorkerCP() != null && System.getProperty("compss.worker.cp") == null) {
                    System.setProperty("compss.worker.cp", manager.getWorkerCP());
                }
                if (manager.getWorkerJVMOpts() != null && System.getProperty("compss.worker.jvm_opts") == null) {
                    System.setProperty("compss.worker.jvm_opts", manager.getWorkerJVMOpts());
                }
                if (System.getProperty("compss.worker.cpu_affinity") == null || System.getProperty("compss.worker.cpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.cpu_affinity", Boolean.toString(manager.isWorkerCPUAffinityEnabled()));
                }
                if (System.getProperty("compss.worker.gpu_affinity") == null || System.getProperty("compss.worker.gpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.gpu_affinity", Boolean.toString(manager.isWorkerGPUAffinityEnabled()));
                }
                if (manager.getServiceName() != null && System.getProperty("compss.serviceName") == null) {
                    System.setProperty("compss.serviceName", manager.getServiceName());
                }
                if (System.getProperty("compss.comm") == null) {
                    if (manager.getCommAdaptor() != null) {
                        System.setProperty("compss.comm", manager.getCommAdaptor());
                    } else {
                        System.setProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
                    }
                }
                if (System.getProperty("compss.conn") == null) {
                    if (manager.getConn() != null) {
                        System.setProperty("compss.conn", manager.getConn());
                    } else {
                        System.setProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
                    }
                }
                if (System.getProperty("gat.debug") == null) {
                    System.setProperty("gat.debug", Boolean.toString(manager.isGATDebug()));
                }
                if (System.getProperty("compss.lang") == null) {
                    System.setProperty("compss.lang", manager.getLang());
                }
                if (System.getProperty("compss.graph") == null) {
                    System.setProperty("compss.graph", Boolean.toString(manager.isGraph()));
                }
                if (System.getProperty("compss.tracing") == null) {
                    System.setProperty("compss.tracing", String.valueOf(manager.getTracing()));
                }
                if (System.getProperty("compss.extrae.file") == null) {
                    System.setProperty("compss.extrae.file", manager.getCustomExtraeFile());
                }
                if (System.getProperty("compss.task.execution") == null || System.getProperty("compss.task.execution").equals("")) {
                    System.setProperty("compss.task.execution", COMPSsConstants.TaskExecution.COMPSS.toString());
                }
                if (manager.getContext() != null) {
                    System.setProperty("compss.context", manager.getContext());
                }
                System.setProperty("compss.to.file", Boolean.toString(manager.isToFile()));
            } else {
                COMPSsRuntimeImpl.setDefaultProperties();
            }
        }
        catch (Exception e) {
            System.err.println(WARN_IT_FILE_NOT_READ);
            e.printStackTrace();
        }
    }

    private static void setDefaultProperties() {
        System.err.println(WARN_FILE_EMPTY_DEFAULT);
        if (System.getProperty("compss.uuid") == null || System.getProperty("compss.uuid").isEmpty()) {
            System.setProperty("compss.uuid", COMPSsConstants.DEFAULT_DEPLOYMENT_ID);
        }
        if (System.getProperty("compss.resources.schema") == null || System.getProperty("compss.resources.schema").isEmpty()) {
            System.setProperty("compss.resources.schema", COMPSsConstants.DEFAULT_RES_SCHEMA);
        }
        if (System.getProperty("compss.project.schema") == null || System.getProperty("compss.project.schema").isEmpty()) {
            System.setProperty("compss.project.schema", COMPSsConstants.DEFAULT_PROJECT_SCHEMA);
        }
        if (System.getProperty("gat.adaptor.path") == null || System.getProperty("gat.adaptor.path").isEmpty()) {
            System.setProperty("gat.adaptor.path", COMPSsConstants.DEFAULT_GAT_ADAPTOR_LOCATION);
        }
        if (System.getProperty("compss.comm") == null || System.getProperty("compss.comm").isEmpty()) {
            System.setProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
        }
        if (System.getProperty("compss.conn") == null || System.getProperty("compss.conn").isEmpty()) {
            System.setProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
        }
        if (System.getProperty("compss.scheduler") == null || System.getProperty("compss.scheduler").isEmpty()) {
            System.setProperty("compss.scheduler", "es.bsc.compss.components.impl.TaskScheduler");
        }
        if (System.getProperty("compss.tracing") == null || System.getProperty("compss.tracing").isEmpty()) {
            System.setProperty("compss.tracing", "0");
        }
        if (System.getProperty("compss.extrae.file") == null || System.getProperty("compss.extrae.file").isEmpty()) {
            System.setProperty("compss.extrae.file", "null");
        }
        if (System.getProperty("compss.task.execution") == null || System.getProperty("compss.task.execution").isEmpty()) {
            System.setProperty("compss.task.execution", COMPSsConstants.TaskExecution.COMPSS.toString());
        }
    }

    private static InputStream findPropertiesConfigFile() {
        InputStream stream = COMPSsRuntimeImpl.class.getResourceAsStream("compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getResourceAsStream(File.separator + "compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream("compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream(File.separator + "compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = ClassLoader.getSystemResourceAsStream("compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = ClassLoader.getSystemResourceAsStream(File.separator + "compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream("compss.properties");
        if (stream != null) {
            return stream;
        }
        stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream(File.separator + "compss.properties");
        if (stream != null) {
            return stream;
        }
        return null;
    }

    public COMPSsRuntimeImpl() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("/version.properties"));
            COMPSs_VERSION = props.getProperty("compss.version");
            COMPSs_BUILDNUMBER = props.getProperty("compss.build");
        }
        catch (IOException e) {
            LOGGER.warn(WARN_VERSION_PROPERTIES);
        }
        if (COMPSs_VERSION == null) {
            LOGGER.debug("Deploying COMPSs Runtime");
        } else if (COMPSs_BUILDNUMBER == null) {
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION);
        } else if (COMPSs_BUILDNUMBER.endsWith("rnull")) {
            COMPSs_BUILDNUMBER = COMPSs_BUILDNUMBER.substring(0, COMPSs_BUILDNUMBER.length() - 6);
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        } else {
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        }
        ErrorManager.init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startIT() {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
            Tracer.emitEvent(TraceEvent.START.getId(), TraceEvent.START.getType());
        }
        Thread.currentThread().setName("APPLICATION");
        if (COMPSs_VERSION == null) {
            LOGGER.warn("Starting COMPSs Runtime");
        } else if (COMPSs_BUILDNUMBER == null) {
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION);
        } else if (COMPSs_BUILDNUMBER.endsWith("rnull")) {
            COMPSs_BUILDNUMBER = COMPSs_BUILDNUMBER.substring(0, COMPSs_BUILDNUMBER.length() - 6);
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        } else {
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        }
        if (!initialized) {
            COMPSsRuntimeImpl cOMPSsRuntimeImpl = this;
            synchronized (cOMPSsRuntimeImpl) {
                LOGGER.debug("Initializing components");
                td = new TaskDispatcher();
                ap = new AccessProcessor(td);
                if (GraphGenerator.isEnabled()) {
                    graphMonitor = new GraphGenerator();
                    ap.setGM(graphMonitor);
                }
                if (RuntimeMonitor.isEnabled()) {
                    runtimeMonitor = new RuntimeMonitor(ap, td, graphMonitor, Long.parseLong(System.getProperty("compss.monitor")));
                }
                initialized = true;
                LOGGER.debug("Ready to process tasks");
            }
        }
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        LOGGER.debug("Initializing " + className + "Itf");
        try {
            td.addInterface(Class.forName(className + "Itf"));
        }
        catch (ClassNotFoundException cnfe) {
            ErrorManager.fatal("Error adding interface " + className + "Itf", cnfe);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
    }

    @Override
    public void fatalError() {
        this.stopIT(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopIT(boolean terminate) {
        COMPSsRuntimeImpl cOMPSsRuntimeImpl = this;
        synchronized (cOMPSsRuntimeImpl) {
            boolean taskSummaryEnabled;
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(TraceEvent.STOP.getId(), TraceEvent.STOP.getType());
            }
            boolean bl = taskSummaryEnabled = System.getProperty("compss.summary") != null && !System.getProperty("compss.summary").isEmpty() && Boolean.parseBoolean(System.getProperty("compss.summary"));
            if (taskSummaryEnabled) {
                td.getTaskSummary(LOGGER);
            }
            LOGGER.info("Stop IT reached");
            if (GraphGenerator.isEnabled()) {
                LOGGER.debug("Stopping Graph generation...");
            }
            if (RuntimeMonitor.isEnabled()) {
                LOGGER.debug("Stopping Monitor...");
                runtimeMonitor.shutdown();
            }
            LOGGER.debug("Stopping AP...");
            if (ap != null) {
                ap.shutdown();
            } else {
                LOGGER.debug("AP was not initialized...");
            }
            LOGGER.debug("Stopping TD...");
            if (td != null) {
                td.shutdown();
            } else {
                LOGGER.debug("TD was not initialized...");
            }
            LOGGER.debug("Stopping Comm...");
            Comm.stop(CoreManager.getSignaturesToCoreIds());
            LOGGER.debug("Runtime stopped");
        }
        LOGGER.warn("Execution Finished");
    }

    @Override
    public String getApplicationDirectory() {
        return Comm.getAppHost().getAppLogDirPath();
    }

    public static ActionOrchestrator getOrchestrator() {
        return td;
    }

    @Override
    public void registerCoreElement(String coreElementSignature, String implSignature, String implConstraints, String implType, String ... implTypeArgs) {
        LOGGER.info("Registering CoreElement " + coreElementSignature);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\t - Implementation: " + implSignature);
            LOGGER.debug("\t - Constraints   : " + implConstraints);
            LOGGER.debug("\t - Type          : " + implType);
            LOGGER.debug("\t - ImplTypeArgs  : ");
            for (String implTypeArg : implTypeArgs) {
                LOGGER.debug("\t\t Arg: " + implTypeArg);
            }
        }
        MethodResourceDescription mrd = new MethodResourceDescription(implConstraints);
        CoreElementDefinition ced = new CoreElementDefinition();
        ced.setCeSignature(coreElementSignature);
        ImplementationDefinition<MethodResourceDescription> implDef = ImplementationDefinition.defineImplementation(implType, implSignature, mrd, implTypeArgs);
        ced.addImplementation(implDef);
        td.registerNewCoreElement(ced);
    }

    public void registerCoreElement(CoreElementDefinition ced) {
        LOGGER.info("Registering CoreElement " + ced.getCeSignature());
        if (LOGGER.isDebugEnabled()) {
            int implId = 0;
            for (ImplementationDefinition<?> implDef : ced.getImplementations()) {
                LOGGER.debug("\t - Implementation " + implId + ":");
                LOGGER.debug(implDef.toString());
            }
        }
        td.registerNewCoreElement(ced);
    }

    @Override
    public void registerData(DataType type, Object stub, String data) {
        switch (type) {
            case FILE_T: {
                try {
                    String fileName = (String)stub;
                    new File(fileName).getName();
                }
                catch (NullPointerException npe) {
                    LOGGER.error(ERROR_FILE_NAME, (Throwable)npe);
                    ErrorManager.fatal(ERROR_FILE_NAME, npe);
                }
                break;
            }
            case OBJECT_T: 
            case PSCO_T: {
                int pscoCode = oReg.newObjectParameter(stub);
                ap.registerRemoteObject(pscoCode, data);
                break;
            }
            case STREAM_T: {
                break;
            }
            case EXTERNAL_STREAM_T: {
                try {
                    String fileName = (String)stub;
                    new File(fileName).getName();
                }
                catch (NullPointerException npe) {
                    LOGGER.error(ERROR_FILE_NAME, (Throwable)npe);
                    ErrorManager.fatal(ERROR_FILE_NAME, npe);
                }
                break;
            }
            case EXTERNAL_PSCO_T: {
                break;
            }
            case BINDING_OBJECT_T: {
                String value = (String)stub;
                if (value.contains(":")) {
                    String[] fields = value.split(":");
                    if (fields.length == 3) {
                        String extObjectId = fields[0];
                        int extObjectType = Integer.parseInt(fields[1]);
                        int extObjectElements = Integer.parseInt(fields[2]);
                        new BindingObject(extObjectId, extObjectType, extObjectElements);
                        this.externalObjectHashcode(extObjectId);
                        break;
                    }
                    LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    break;
                }
                LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                break;
            }
            case COLLECTION_T: {
                throw new UnsupportedOperationException("Not implemented yet.");
            }
        }
    }

    @Override
    public int executeTask(Long appId, String methodClass, String onFailure, int timeOut, String methodName, boolean isPrioritary, boolean hasTarget, Integer numReturns, int parameterCount, Object ... parameters) {
        boolean isReplicated = Boolean.parseBoolean("false");
        boolean isDistributed = Boolean.parseBoolean("false");
        return this.executeTask(appId, null, null, false, methodClass, methodName, null, OnFailure.valueOf(onFailure), timeOut, isPrioritary, 1, isReplicated, isDistributed, hasTarget, numReturns, parameterCount, parameters);
    }

    @Override
    public int executeTask(Long appId, String signature, String onFailure, int timeOut, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, Integer numReturns, int parameterCount, Object ... parameters) {
        return this.executeTask(appId, null, null, true, null, null, signature, OnFailure.valueOf(onFailure), timeOut, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, numReturns, parameterCount, parameters);
    }

    @Override
    public int executeTask(Long appId, TaskMonitor monitor, COMPSsConstants.Lang lang, String methodClass, String methodName, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int parameterCount, OnFailure onFailure, int timeOut, Object ... parameters) {
        return this.executeTask(appId, monitor, lang, false, methodClass, methodName, null, onFailure, timeOut, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, null, parameterCount, parameters);
    }

    @Override
    public int executeTask(Long appId, TaskMonitor monitor, String namespace, String service, String port, String operation, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int parameterCount, OnFailure onFailure, int timeOut, Object ... parameters) {
        List<Parameter> pars;
        boolean hasReturn;
        int numReturns;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.TASK.getId(), TraceEvent.TASK.getType());
        }
        if (numNodes != 1 || isReplicated || isDistributed) {
            ErrorManager.fatal("ERROR: Unsupported feature for Services: multi-node, replicated or distributed");
        }
        LOGGER.info("Creating task from service " + service + ", namespace " + namespace + ", port " + port + ", operation " + operation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("There " + (parameterCount > 1 ? "are " : "is ") + parameterCount + " parameter" + (parameterCount > 1 ? "s" : ""));
        }
        int n = numReturns = (hasReturn = this.hasReturn(pars = this.processParameters(parameterCount, parameters))) ? 1 : 0;
        if (monitor == null) {
            monitor = DO_NOTHING_MONITOR;
        }
        int task = ap.newTask(appId, monitor, namespace, service, port, operation, isPrioritary, hasTarget, numReturns, pars, onFailure, timeOut);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return task;
    }

    public int executeTask(Long appId, TaskMonitor monitor, COMPSsConstants.Lang lang, boolean hasSignature, String methodClass, String methodName, String signature, OnFailure onFailure, int timeOut, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, Integer numReturns, int parameterCount, Object ... parameters) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.TASK.getId(), TraceEvent.TASK.getType());
        }
        if (hasSignature) {
            LOGGER.info("Creating task from method " + signature);
        } else {
            LOGGER.info("Creating task from method " + methodName + " in " + methodClass);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("There " + (parameterCount == 1 ? "is " : "are ") + parameterCount + " parameter" + (parameterCount > 1 ? "s" : ""));
        }
        List<Parameter> pars = this.processParameters(parameterCount, parameters);
        if (numReturns == null) {
            numReturns = this.hasReturn(pars) ? 1 : 0;
        }
        if (!hasSignature) {
            signature = MethodImplementation.getSignature(methodClass, methodName, hasTarget, numReturns, pars);
        }
        if (monitor == null) {
            monitor = DO_NOTHING_MONITOR;
        }
        if (lang == null) {
            lang = DEFAULT_LANG;
        }
        int task = ap.newTask(appId, monitor, lang, signature, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, numReturns, pars, onFailure, timeOut);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return task;
    }

    private boolean hasReturn(List<Parameter> parameters) {
        boolean hasReturn = false;
        if (parameters.size() != 0) {
            Parameter lastParam = parameters.get(parameters.size() - 1);
            DataType type = lastParam.getType();
            hasReturn = lastParam.getDirection() == Direction.OUT && (type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T);
        }
        return hasReturn;
    }

    @Override
    public void noMoreTasks(Long appId) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.NO_MORE_TASKS.getId(), TraceEvent.NO_MORE_TASKS.getType());
        }
        LOGGER.info("No more tasks for app " + appId);
        ap.noMoreTasks(appId);
        LOGGER.debug("Getting Result Files " + appId);
        ap.getResultFiles(appId);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
    }

    @Override
    public void barrier(Long appId) {
        this.barrier(appId, false);
    }

    @Override
    public void barrier(Long appId, boolean noMoreTasks) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.WAIT_FOR_ALL_TASKS.getId(), TraceEvent.WAIT_FOR_ALL_TASKS.getType());
        }
        LOGGER.info("Barrier for app " + appId + " with noMoreTasks = " + noMoreTasks);
        if (noMoreTasks) {
            this.noMoreTasks(appId);
        } else {
            ap.barrier(appId);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.WAIT_FOR_ALL_TASKS.getType());
        }
    }

    @Override
    public void barrierGroup(Long appId, String groupName) throws COMPSsException {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.WAIT_FOR_ALL_TASKS.getId(), TraceEvent.WAIT_FOR_ALL_TASKS.getType());
        }
        ap.barrierGroup(appId, groupName);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.WAIT_FOR_ALL_TASKS.getType());
        }
    }

    @Override
    public boolean deleteFile(String fileName) {
        return this.deleteFile(fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(String fileName, boolean waitForData) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        LOGGER.info("Deleting File " + fileName);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.DELETE.getId(), TraceEvent.DELETE.getType());
        }
        try {
            DataLocation loc = this.createLocation(fileName);
            ap.markForDeletion(loc, waitForData);
            if (sReg != null) {
                sReg.deleteTaskFile(fileName);
            }
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
            }
        }
        return true;
    }

    @Override
    public void emitEvent(int type, long id) {
        Tracer.emitEvent(id, type);
    }

    @Override
    public void openTaskGroup(String groupName, boolean implicitBarrier, Long appId) {
        ap.setCurrentTaskGroup(groupName, implicitBarrier, appId);
    }

    @Override
    public void closeTaskGroup(String groupName, Long appId) {
        ap.closeCurrentTaskGroup(appId);
    }

    @Override
    public void getFile(Long appId, String fileName) {
        String destDir;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.GET_FILE.getId(), TraceEvent.GET_FILE.getType());
        }
        if (!(destDir = Comm.getAppHost().getTempDirPath()).endsWith(File.separator)) {
            destDir = destDir + File.separator;
        }
        DataLocation sourceLocation = null;
        try {
            sourceLocation = this.createLocation(fileName);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
        }
        if (sourceLocation == null) {
            ErrorManager.fatal(ERROR_FILE_NAME);
        }
        LOGGER.debug("Getting file " + fileName);
        String renamedPath = this.openFile(fileName, Direction.INOUT);
        if (!renamedPath.equals(sourceLocation.getPath())) {
            String intermediateTmpPath = renamedPath + ".tmp";
            this.rename(renamedPath, intermediateTmpPath);
            this.closeFile(fileName, Direction.INOUT);
            ap.markForDeletion(sourceLocation, true);
            if (sReg != null) {
                sReg.deleteTaskFile(fileName);
            }
            this.rename(intermediateTmpPath, fileName);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
    }

    private void rename(String source, String target) {
        Path sourcePath = Paths.get(source, new String[0]);
        Path destinationPath = Paths.get(target, new String[0]);
        LOGGER.info("Moving file from " + source + " to " + target);
        try {
            Files.move(sourcePath, destinationPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            try {
                Files.move(sourcePath, destinationPath, new CopyOption[0]);
            }
            catch (IOException e1) {
                LOGGER.error("Move not possible ", (Throwable)e1);
            }
        }
        catch (IOException e) {
            LOGGER.error("Atomic move not possible ", (Throwable)e);
        }
    }

    @Override
    public Object getObject(Object obj, int hashCode, String destDir) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.GET_OBJECT.getId(), TraceEvent.GET_OBJECT.getType());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting object with hash code " + hashCode);
        }
        Object oUpdated = this.mainAccessToObject(obj, hashCode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Object obtained " + (oUpdated == null ? oUpdated : Integer.valueOf(oUpdated.hashCode())));
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return oUpdated;
    }

    @Override
    public void serializeObject(Object o, int hashCode, String destDir) {
    }

    @Override
    public ObjectRegistry getObjectRegistry() {
        return oReg;
    }

    @Override
    public StreamRegistry getStreamRegistry() {
        return sReg;
    }

    @Override
    public void setObjectRegistry(ObjectRegistry oReg) {
        COMPSsRuntimeImpl.oReg = oReg;
    }

    @Override
    public void setStreamRegistry(StreamRegistry sReg) {
        COMPSsRuntimeImpl.sReg = sReg;
    }

    @Override
    public String getTempDir() {
        return Comm.getAppHost().getTempDirPath();
    }

    @Override
    public String openFile(String fileName, Direction mode) {
        String finalPath;
        DataLocation loc;
        LOGGER.info("Opening " + fileName + " in mode " + (Object)((Object)mode));
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.OPEN_FILE.getId(), TraceEvent.OPEN_FILE.getType());
        }
        try {
            loc = this.createLocation(fileName);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
            return null;
        }
        AccessParams.AccessMode am = null;
        switch (mode) {
            case IN: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessParams.AccessMode.CV;
            }
        }
        switch (loc.getType()) {
            case PRIVATE: 
            case SHARED: {
                finalPath = this.mainAccessToFile(fileName, loc, am, null);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("File target Location: " + finalPath);
                break;
            }
            case PERSISTENT: {
                finalPath = this.mainAccessToExternalPSCO(fileName, loc);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("External PSCO target Location: " + finalPath);
                break;
            }
            default: {
                finalPath = null;
                ErrorManager.error("ERROR: Unrecognised protocol requesting openFile " + fileName);
            }
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return finalPath;
    }

    @Override
    public void closeFile(String fileName, Direction mode) {
        DataLocation loc;
        LOGGER.info("Closing " + fileName + " in mode " + (Object)((Object)mode));
        try {
            loc = this.createLocation(fileName);
        }
        catch (Exception e) {
            ErrorManager.fatal(ERROR_FILE_NAME, e);
            return;
        }
        AccessParams.AccessMode am = null;
        switch (mode) {
            case IN: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessParams.AccessMode.CV;
            }
        }
        switch (loc.getType()) {
            case PRIVATE: 
            case SHARED: {
                this.finishAccessToFile(fileName, loc, am, null);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("Closing file " + loc.getPath());
                break;
            }
            case PERSISTENT: {
                ErrorManager.warn("WARN: Cannot close file " + fileName + " with PSCO protocol");
                break;
            }
            case BINDING: {
                ErrorManager.warn("WARN: Cannot close binding object " + fileName + " with PSCO protocol");
                break;
            }
            default: {
                ErrorManager.error("ERROR: Unrecognised protocol requesting closeFile " + fileName);
            }
        }
    }

    @Override
    public String getBindingObject(String fileName) {
        LOGGER.debug(" Calling get binding object : " + fileName);
        BindingObjectLocation sourceLocation = new BindingObjectLocation(Comm.getAppHost(), BindingObject.generate(fileName));
        String finalPath = this.mainAccessToBindingObject(fileName, sourceLocation);
        LOGGER.debug(" Returning binding object as id: " + finalPath);
        return finalPath;
    }

    @Override
    public boolean deleteBindingObject(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        LOGGER.info("Deleting BindingObject " + fileName);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.DELETE.getId(), TraceEvent.DELETE.getType());
        }
        BindingObject bo = BindingObject.generate(fileName);
        int hashCode = this.externalObjectHashcode(bo.getId());
        ap.markForBindingObjectDeletion(hashCode);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        }
        return true;
    }

    private int addParameter(Object content, DataType type, Direction direction, StdIOStream stream, String prefix, String name, ArrayList<Parameter> pars, int offset, String[] vals) {
        switch (type) {
            case FILE_T: {
                try {
                    String fileName = (String)content;
                    String originalName = new File(fileName).getName();
                    DataLocation location = this.createLocation((String)content);
                    pars.add(new FileParameter(direction, stream, prefix, name, location, originalName));
                }
                catch (Exception e) {
                    LOGGER.error(ERROR_FILE_NAME, (Throwable)e);
                    ErrorManager.fatal(ERROR_FILE_NAME, e);
                }
                break;
            }
            case OBJECT_T: 
            case PSCO_T: {
                int code = oReg.newObjectParameter(content);
                pars.add(new ObjectParameter(direction, stream, prefix, name, content, code));
                break;
            }
            case STREAM_T: {
                int streamCode = oReg.newObjectParameter(content);
                pars.add(new StreamParameter(direction, stream, prefix, name, content, streamCode));
                break;
            }
            case EXTERNAL_STREAM_T: {
                try {
                    String fileName = (String)content;
                    String canonicalPath = new File(fileName).getCanonicalPath();
                    String locationPath = ProtocolType.EXTERNAL_STREAM_URI.getSchema() + canonicalPath;
                    DataLocation location = this.createLocation(locationPath);
                    String originalName = new File(fileName).getName();
                    pars.add(new ExternalStreamParameter(direction, stream, prefix, name, location, originalName));
                }
                catch (Exception e) {
                    LOGGER.error(ERROR_FILE_NAME, (Throwable)e);
                    ErrorManager.fatal(ERROR_FILE_NAME, e);
                }
                break;
            }
            case EXTERNAL_PSCO_T: {
                String id = (String)content;
                pars.add(new ExternalPSCOParameter(direction, stream, prefix, name, id, this.externalObjectHashcode(id)));
                break;
            }
            case BINDING_OBJECT_T: {
                String value = (String)content;
                if (value.contains(":")) {
                    String[] fields = value.split(":");
                    if (fields.length == 3) {
                        String extObjectId = fields[0];
                        int extObjectType = Integer.parseInt(fields[1]);
                        int extObjectElements = Integer.parseInt(fields[2]);
                        pars.add(new BindingObjectParameter(direction, stream, prefix, name, new BindingObject(extObjectId, extObjectType, extObjectElements), this.externalObjectHashcode(extObjectId)));
                        break;
                    }
                    LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    break;
                }
                LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                break;
            }
            case COLLECTION_T: {
                String[] values = vals == null ? ((String)content).split(" ") : vals;
                String collectionId = values[offset];
                int numOfElements = Integer.parseInt(values[offset + 1]);
                ArrayList<DataType> contentTypes = new ArrayList<DataType>();
                ArrayList<String> contentIds = new ArrayList<String>();
                ArrayList<Parameter> collectionParameters = new ArrayList<Parameter>();
                int ret = 2;
                for (int j = 0; j < numOfElements; ++j) {
                    int idx = Integer.parseInt(values[offset + ret]);
                    DataType dataType = DataType.values()[idx];
                    contentTypes.add(dataType);
                    contentIds.add(values[offset + ret + 1]);
                    DataType elemType = (DataType)((Object)contentTypes.get(j));
                    Direction elemDir = direction;
                    String[] elemContent = elemType == DataType.COLLECTION_T ? values : contentIds.get(j);
                    StdIOStream elemStream = StdIOStream.UNSPECIFIED;
                    String elemPrefix = "null";
                    String elemName = name + "." + j;
                    if (!elemName.startsWith("@")) {
                        elemName = "@" + elemName;
                    }
                    ret += this.addParameter(elemContent, elemType, elemDir, elemStream, elemPrefix, elemName, collectionParameters, offset + ret + 1, values) + 1;
                }
                CollectionParameter cp = new CollectionParameter(collectionId, collectionParameters, direction, stream, prefix, name);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Add COLLECTION " + cp.getName() + "  with " + cp.getParameters().size() + " parameters");
                    LOGGER.debug(cp.toString());
                }
                pars.add(cp);
                return ret;
            }
            default: {
                if (direction != Direction.IN) {
                    LOGGER.warn("WARNING: Invalid parameter direction: Parameter " + name + " is a basic type, therefore it must have IN direction");
                }
                pars.add(new BasicTypeParameter(type, Direction.IN, stream, prefix, name, content));
            }
        }
        return 1;
    }

    @Override
    public void cancelApplicationTasks(Long appId) {
        ap.cancelApplicationTasks(appId);
    }

    private List<Parameter> processParameters(int parameterCount, Object[] parameters) {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        for (int i = 0; i < parameterCount; ++i) {
            Object content = parameters[6 * i];
            DataType type = (DataType)((Object)parameters[6 * i + 1]);
            Direction direction = (Direction)((Object)parameters[6 * i + 2]);
            StdIOStream stream = (StdIOStream)((Object)parameters[6 * i + 3]);
            String prefix = (String)parameters[6 * i + 4];
            String name = (String)parameters[6 * i + 5];
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  Parameter " + i + " has type " + type.name());
            }
            this.addParameter(content, type, direction, stream, prefix, name, pars, 0, null);
        }
        return pars;
    }

    private int externalObjectHashcode(String id) {
        int hashCode = 7;
        for (int i = 0; i < id.length(); ++i) {
            hashCode = hashCode * 31 + id.charAt(i);
        }
        return hashCode;
    }

    private void finishAccessToFile(String fileName, DataLocation loc, AccessParams.AccessMode am, String destDir) {
        FileAccessParams fap = new FileAccessParams(am, ap.getDataInfoProvider(), loc);
        ap.finishAccessToFile(loc, fap, destDir);
    }

    private String mainAccessToFile(String fileName, DataLocation loc, AccessParams.AccessMode am, String destDir) {
        DataLocation finalLocation;
        FileAccessParams fap = new FileAccessParams(am, ap.getDataInfoProvider(), loc);
        DataLocation targetLocation = ap.mainAccessToFile(loc, fap, destDir);
        String path = targetLocation == null ? fileName : targetLocation.getPath();
        DataLocation dataLocation = finalLocation = targetLocation == null ? loc : targetLocation;
        if (finalLocation == null) {
            ErrorManager.fatal(ERROR_FILE_NAME);
            return null;
        }
        MultiURI u = finalLocation.getURIInHost(Comm.getAppHost());
        String finalPath = u != null ? u.getPath() : path;
        return finalPath;
    }

    private Object mainAccessToObject(Object obj, int hashCode) {
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return null;
        }
        return ap.mainAcessToObject(obj, hashCode);
    }

    private String mainAccessToExternalPSCO(String fileName, DataLocation loc) {
        String id = ((PersistentLocation)loc).getId();
        int hashCode = this.externalObjectHashcode(id);
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return fileName;
        }
        return ap.mainAcessToExternalPSCO(id, hashCode);
    }

    private String mainAccessToBindingObject(String fileName, BindingObjectLocation loc) {
        String id = loc.getId();
        int hashCode = this.externalObjectHashcode(id);
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return fileName;
        }
        return ap.mainAcessToBindingObject(loc.getBindingObject(), hashCode);
    }

    private DataLocation createLocation(String fileName) throws IOException {
        SimpleURI uri = new SimpleURI(fileName);
        if (uri.getSchema().isEmpty()) {
            String canonicalPath = new File(fileName).getCanonicalPath();
            uri = new SimpleURI(ProtocolType.FILE_URI.getSchema() + canonicalPath);
        }
        Resource host = Comm.getAppHost();
        String hostName = uri.getHost();
        if (hostName != null && !hostName.isEmpty() && (host = ResourcesPool.getResource(hostName)) == null) {
            ErrorManager.error("Host " + hostName + " not found when creating data location.");
        }
        return DataLocation.createLocation(host, uri);
    }

    @Override
    public void deregisterObject(Long appId, Object o) {
        oReg.delete(o);
    }

    @Override
    public void removeObject(Object o, int hashcode) {
        ap.deregisterObject(o);
    }

    static {
        LOGGER = LogManager.getLogger("es.bsc.compss.API");
        DO_NOTHING_MONITOR = new DoNothingTaskMonitor();
        String propertiesLoc = System.getProperty("compss.properties.location");
        if (propertiesLoc == null) {
            InputStream stream = COMPSsRuntimeImpl.findPropertiesConfigFile();
            if (stream != null) {
                try {
                    COMPSsRuntimeImpl.setPropertiesFromRuntime(new RuntimeConfigManager(stream));
                }
                catch (Exception e) {
                    System.err.println(WARN_IT_FILE_NOT_READ);
                    e.printStackTrace();
                }
            } else {
                COMPSsRuntimeImpl.setDefaultProperties();
            }
        } else {
            try {
                COMPSsRuntimeImpl.setPropertiesFromRuntime(new RuntimeConfigManager(propertiesLoc));
            }
            catch (Exception e) {
                System.err.println(WARN_IT_FILE_NOT_READ);
                e.printStackTrace();
            }
        }
        Comm.init(new MasterResourceImpl());
    }
}

